<?php

namespace App\Http\Controllers\Site\Result;


use App\Models\Academic\AcademicExamType;
use App\Models\Academic\AcademicResultCombineType;
use App\Models\Academic\AcademicResultPrimaryType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;

use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Result\SiteIndividualCombineSubjectResultStore;
use App\Models\Site\Result\SiteStudentCombineResultDetail;
use App\Models\Site\Result\SiteIndividualSubjectResultStore;
use App\Models\Site\Result\SiteResultCombineSetting;
use App\Models\Site\Result\SiteResultPrimarySetting;
use App\Models\Site\Result\SiteResultSystemSetting;
use App\Models\Site\Result\SiteStudentPrimaryResultDetail;
use App\Models\Site\Result\SiteStudentPrimaryResultDetailForTabulation;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use Carbon\Carbon;
use DateTime;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ProjectController;
use Illuminate\Support\Facades\Log;
use Response;
use Session;
use App\Models\Academic\AcademicSubjectClassExamCondition;
use App\Models\Academic\AcademicSubject;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Attendance\StudentAttendance;
use App\Models\Event\Event;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;

class SiteBaseResultGenerateController extends ProjectController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');
    }

    public function index()
    {
        $viewType = 'Site Result Setting Page';

        return view('default.admin.layouts.master', compact('viewType'));
        //        return view('default.admin.site.result.site-base-result-generate', compact('viewType'));
    }



    public function getSiteBaseResultTypeListForResultGenerate(Request $request)
    {

        $data = $request->all();

        $resultSettingList = SiteResultPrimarySetting::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();

        //            ->distinct('academic_result_primary_type_id')
        //            ->pluck('academic_result_primary_type_id');


        $resultSettingListIds = $resultSettingList->pluck('academic_result_primary_type_id')->unique()->filter();

        $siteExamDeclares = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        //  return $resultSettingListIds;

        $academic_result_primary_type_id_array = [];
        foreach ($resultSettingListIds as $key => $value) {

            $ExaminationFromSetting = $resultSettingList->where('academic_result_primary_type_id', $value);
            $ExaminationIDsFromSetting = $ExaminationFromSetting->pluck('examination_id')->unique();
            $countExaminationFromSetting = count($ExaminationIDsFromSetting);

            $ExaminationFromExamDeclare = $siteExamDeclares->whereIn('examination_id', $ExaminationIDsFromSetting);
            $ExaminationIDsFromExamDeclare = $ExaminationFromExamDeclare->pluck('examination_id')->unique();
            $countExaminationFromExamDeclare = count($ExaminationIDsFromExamDeclare);

            if ($countExaminationFromSetting == $countExaminationFromExamDeclare) {
                $academic_result_primary_type_id_array[] = $value;
            }
        }
        //  dd($academic_result_primary_type_id_array);
        $resultlist_test = AcademicResultPrimaryType::whereIn('id', $academic_result_primary_type_id_array)->get();
        //  dd($resultlist_test);
        $test_arr = array();
        $resultlist = [];
        foreach ($resultlist_test as $key => $value) {

            $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                //                ->where('status', true)
                ->pluck('id');


            $check_result_present = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->pluck('id');

            if (count($check_result_present) > 0) {
                $test_arr['result_generate_status'] = true;
            } else {
                $test_arr['result_generate_status'] = false;
            }


            $check_result__publish_emp_panel = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_employee_publish_status', true)
                ->first();

            $check_result_publish_std_panel = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_student_publish_status', true)
                ->first();

            $check_result_publish_public = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
                ->where('academic_result_primary_type_id', $value->id)
                ->where('result_public_publish_status', true)
                ->first();

            if ($check_result__publish_emp_panel) {
                $test_arr['result_employee_publish_status'] = true;
            } else {
                $test_arr['result_employee_publish_status'] = false;
            }


            if ($check_result_publish_std_panel) {
                $test_arr['result_student_publish_status'] = true;
            } else {
                $test_arr['result_student_publish_status'] = false;
            }

            if ($check_result_publish_public) {
                $test_arr['result_public_publish_status'] = true;
            } else {
                $test_arr['result_public_publish_status'] = false;
            }



            $test_arr['loading_result_generate_image'] = false;

            $resultlist[$key] = array_merge($test_arr, $value->toArray());
        }
        return $resultlist;
    }



    public function createUpdateResultListForResultGenerate(Request $request)
    {


        $data = $request->all();

        $resultSettingList = SiteResultPrimarySetting::with(['academicResultPrimaryType', 'examination'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->orderBy('show_position', 'asc')
            ->get(['id', 'academic_result_primary_type_id', 'examination_id', 'marks_percentage', 'show_position', 'math_condition']);

        if (!count($resultSettingList)) {
            return Response::json('Undefine settings', 410);
        }

        $math_condition = $resultSettingList[0]['math_condition'];

        $resultSettingListIds = $resultSettingList->pluck('examination_id');

        $examDeclareList = SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->whereIn('examination_id', $resultSettingListIds)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $subject_condition_setting = SubjectGroupConditionSetting::with([
            'academicSubjectClassExamCondition',
            'examDependentAcademicSubject',
            'siteSubjectExaminationMark'
        ])
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get();


        $showTableBellowSubjectIDs = $subject_condition_setting->where('result_show_in_table_bellow', true)
            ->pluck('id')->unique();
        $OtherSubjectIDs = $subject_condition_setting->where('result_show_in_table_bellow', false)
            ->pluck('id')->unique();

        //        $examinationlist=Examination::whereIn('id', $resultSettingList)->get();

        $classAllStudentlist = StudentHistory::where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('status', true)
            ->pluck('id');

           // dd($classAllStudentlist);


        $examDeclareListIDs = $examDeclareList->pluck('id');

        $studentMarksListAll = SiteExamDeclareStudentSubject::with([
            // 'siteSubjectExaminationMark'=>function($query){
            //     $query->with('siteSubjectExaminationExamTypeMark');
            // },
            'examination' => function ($query) {
                $query->get(['id', 'examination_name']);
            },
            'academicExamType' => function ($query) {
                $query->get(['id', 'marks_type']);
            }
        ])
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->whereIn('student_history_id', $classAllStudentlist)
<<<<<<< HEAD
        //    ->where('student_history_id', 103586)
=======

        //    ->where('student_history_id', 75246)
>>>>>>> master
            ->get(['id', 'site_exam_declare_id', 'site_exam_declare_student_id', 'student_history_id',
                'examination_id', 'academic_exam_type_id', 'site_subject_group_condition_setting_id',
            'obtaine_marks', 'pass_mark','countable_obtaine_marks','exam_type_countable_marks_status', 'exam_type_countable_marks', 'exam_type_countable_persent_of_obtain_marks', 'subject_exam_type_mark', 'exam_held_status', 'exam_attendance_status']);

<<<<<<< HEAD
        $studentIdsList=$studentMarksListAll->pluck('student_history_id')->unique()->filter()->values();
        
        $generateStudentRest=array_diff($studentIdsList->toArray(), $request->select_student_history_ids);
=======

        $studentIdsList = $studentMarksListAll->pluck('student_history_id')->unique()->filter()->values();
        //  dd($studentMarksListAll);
        //        Log::info($request->select_student_history_ids);
>>>>>>> master

        $generateStudentRest = array_diff($studentIdsList->toArray(), $request->select_student_history_ids);

        if (count($generateStudentRest) > 0) {
            $tenStudentIDs = collect($generateStudentRest)->take(20);
        } else {
            $tenStudentIDs = [];
        }
       

        $generatedStudentIDs = array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);

        $studentMarksList = $studentMarksListAll->whereIn('student_history_id', $tenStudentIDs);

<<<<<<< HEAD
        $showTableBellowSubjectExamList=SiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
=======
        //  $classAllStudentlist=StudentHistory::whereIn('id', $studentIdsList)->where('status',true)->pluck('id');

        //        $generatedStudentlist=StudentHistory::with(['student'=>function($query){
        //            $query->select('id');
        //        }])
        //            ->whereIn('id', $generatedStudentIDs)
        //            ->orderBy('student_roll_number', 'desc')
        //            ->get(['id', 'user_id']);

        //        return $generatedStudentlist;




        $showTableBellowSubjectExamList = SiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
>>>>>>> master
            ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->get(['examination_id', 'academic_exam_type_id']);


        $OtherSubjectExamList = SiteExamDeclareStudentSubject::distinct('examination_id', 'academic_exam_type_id')
            ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
            ->whereIn('site_exam_declare_id', $examDeclareListIDs)
            ->get(['examination_id', 'academic_exam_type_id']);

        $filter_for_examination_ids = Examination::whereIn('id', $studentMarksList->pluck('examination_id')
            ->unique()
            ->filter())
            ->get(['id', 'examination_name', 'name_key']);

        $exam_type_arr = array();
        $exam_type_array = [];
        foreach ($filter_for_examination_ids as $keys => $value) {

            //            $resultSettingPercentage=$resultSettingList->where('examination_id', $value->id)->first();
            //            if($resultSettingPercentage){
            //
            //            }

            $get_postions = $resultSettingList->where('examination_id', $value->id)->first();

            //    dd($get_postions);
            //return $get_postions->marks_percentage;

            $exam_type_ids = $studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $OtherSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();
            $exam_type_ids_for_table_bellow = $studentMarksList->where('examination_id', $value->id)
                ->whereIn('site_subject_group_condition_setting_id', $showTableBellowSubjectIDs)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();


            // exam position wise serial
            $exam_type_setting = SiteExaminationExamTypeSetting::where('academic_year_id', $request->academic_year_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $value->id)
                ->whereIn('academic_exam_type_id', $exam_type_ids)
                ->orderBy('position_show', 'ASC')
                ->get();

            $exam_type_list = [];
            $key = 0;

            foreach ($exam_type_setting as $type_sett) {

                $exam_type = AcademicExamType::where('id', $type_sett->academic_exam_type_id)->first();

                $exam_type_list[$key]['id'] = $exam_type->id;
                $exam_type_list[$key]['marks_type'] = $exam_type->marks_type;
                $exam_type_list[$key]['head_key'] = $exam_type->head_key;
                $key++;
            }


            $exam_type_list_for_table_bellow = AcademicExamType::whereIn('id', $exam_type_ids_for_table_bellow)->get(['id', 'marks_type']);

            $exam_type_arr['academic_exam_type_list'] = $exam_type_list;
            $exam_type_arr['academic_exam_type_list_for_table_bellow'] = $exam_type_list_for_table_bellow;
            $exam_type_arr['table_bellow_status'] = count($exam_type_list_for_table_bellow) > 0 ? 1 : 0;
            $exam_type_arr['obtain_marks'] = 'Obt';
            $exam_type_arr['academic_exam_type_count'] = count($exam_type_list);
            $exam_type_arr['exam_type_list_for_table_bellow_count'] = count($exam_type_list_for_table_bellow);
            $exam_type_arr['show_position'] = $get_postions->show_position;
            $exam_type_arr['marks_percentage'] = $get_postions->marks_percentage ?? 0;

            $exam_type_array[$keys] = array_merge($exam_type_arr, $value->toArray());
        }




        $exam_type_array_with_sort = array_values(array_sort(collect($exam_type_array), function ($value) {
            return $value['show_position'];
        }));

<<<<<<< HEAD
   
=======
        //  dd($exam_type_array_with_sort);

>>>>>>> master

        $grade_list = SiteResultSystemSetting::with(['academicResultSystem'])
            ->where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            //            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->get()
            ->sortBy(function ($item) {
                return $item->academicResultSystem->serial ?? 0;
            });



        $getStudentOptionalSubject = StudentHistory::where('academic_year_id', $request->academic_year_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->where('status', true)
            ->where('transfer_status', false)
            ->get(['id', 'user_id', 'optional_subject_ids']);

        $academic_result_primary_type_id = $request->academic_result_primary_type_id;


        $student_indivisual_subject_list = $this->studentMarkslist(
            $studentMarksList,
            $grade_list,
            $subject_condition_setting,
            $resultSettingList,
            $getStudentOptionalSubject,
            $academic_result_primary_type_id,
            $showTableBellowSubjectExamList,
            $OtherSubjectExamList,
            $math_condition
        );

        //  return $student_indivisual_subject_list;

        $student_ids = collect($student_indivisual_subject_list)->pluck('student_history_id');

        $getSiteStudentPrimaryResultDetail = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->where('status', true)
            ->get();



        foreach ($student_indivisual_subject_list as $key => $value) {
            //    dd($value['fail_subject_count']);

            $checkStudentResult = $getSiteStudentPrimaryResultDetail->where('student_history_id', $value['student_history_id'])
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)->first();

            if ($checkStudentResult) {
                $checkStudentResult->update([

                    'gpa' => $value['final_point'],
                    'grade' => $value['final_grade'],
                    'fail_subject_count' => $value['fail_subject_count'],


                    'optional_subject_ids' => $value['optional_subject_ids'],
                    'final_point_without_optional' => $value['final_point_without_optional'],
                    'final_grade_without_optional' => $value['final_grade_without_optional'],
                    'combine_subject_present' => $value['combine_subject_present'],
                    'classtest_is_present' => $value['classtest_is_present'],
                    'exam_attendance_status' => $value['exam_attendance_status'],


                    'sum_of_obtain_raw_total_marks' => $this->mathValue($math_condition, $value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks' => $this->mathValue($math_condition, $value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks' => $this->mathValue($math_condition, $value['sum_of_raw_total_marks']),
                    'raw_obtain_marks_percentage' => $value['sum_of_obtain_raw_total_marks'] * 100 /
                        ($value['sum_of_raw_total_marks'] ? $value['sum_of_raw_total_marks'] : 1),



                    'sum_of_same_row_total_marks' => $this->mathValue($math_condition, $value['sum_of_same_row_total_marks']),
                    'sum_of_same_obtain_raw_total_marks' => $this->mathValue($math_condition, $value['sum_of_same_obtain_raw_total_marks']),

                    'sum_of_obtain_raw_total_marks_only_passed_subject' => $this->mathValue($math_condition, $value['sum_of_obtain_raw_total_marks_only_passed_subject']),
                    'pass_subject_base_marks_percentage' => $value['pass_subject_base_marks_percentage'],
                    'total_marks_base_percentage' => $value['total_marks_base_percentage'],
                    'pass_subject_base_marks_grade' => $value['pass_subject_base_marks_grade'],
                    'total_marks_base_grade' => $value['total_marks_base_grade'],
                    'pass_subject_base_marks_point' => $value['pass_subject_base_marks_point'],
                    'total_marks_base_point' => $value['total_marks_base_point'],

                    'sum_of_obtain_total_marks_for_show' => $value['sum_of_obtain_total_marks_for_show'],
                    'sum_of_obtain_total_percent_for_show' => $value['sum_of_obtain_total_percent_for_show'],


                    'table_header' => json_encode($exam_type_array_with_sort),
                    'site_individual_combine_subject_result_store_ids' => implode(',', $value['site_individual_combine_subject_result_store_ids']),
                    'site_id' => Session::get('SITE_ID'),

                ]);
            } else {

                SiteStudentPrimaryResultDetail::create([
                    'academic_result_primary_type_id' => $request->academic_result_primary_type_id,
                    'student_history_id' => $value['student_history_id'],
                    'gpa' => $value['final_point'],
                    'grade' => $value['final_grade'],
                    'fail_subject_count' => $value['fail_subject_count'],
                    'exam_attendance_status' => $value['exam_attendance_status'],

<<<<<<< HEAD
                    'optional_subject_ids'=>$value['optional_subject_ids'],
                    'final_point_without_optional'=>$value['final_point_without_optional'],
                    'final_grade_without_optional'=>$value['final_grade_without_optional'],
                    'combine_subject_present'=>$value['combine_subject_present'],
                    'classtest_is_present'=>$value['classtest_is_present'],

                    'sum_of_obtain_raw_total_marks'=>$this->mathValue($math_condition,$value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks'=>$this->mathValue($math_condition,$value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks'=>$this->mathValue($math_condition,$value['sum_of_raw_total_marks']),
           //         'raw_obtain_marks_percentage'=>$value['sum_of_obtain_raw_total_marks']*100/$value['sum_of_raw_total_marks'],

                    'raw_obtain_marks_percentage'=>$value['sum_of_obtain_raw_total_marks']*100/
                        ($value['sum_of_raw_total_marks']?$value['sum_of_raw_total_marks']:1),
=======

                    'optional_subject_ids' => $value['optional_subject_ids'],
                    'final_point_without_optional' => $value['final_point_without_optional'],
                    'final_grade_without_optional' => $value['final_grade_without_optional'],
                    'combine_subject_present' => $value['combine_subject_present'],
                    'classtest_is_present' => $value['classtest_is_present'],


                    'sum_of_obtain_raw_total_marks' => $this->mathValue($math_condition, $value['sum_of_obtain_raw_total_marks']),
                    'sum_of_obtain_percent_total_marks' => $this->mathValue($math_condition, $value['sum_of_obtain_percent_total_marks']),
                    'sum_of_raw_total_marks' => $this->mathValue($math_condition, $value['sum_of_raw_total_marks']),
                    //         'raw_obtain_marks_percentage'=>$value['sum_of_obtain_raw_total_marks']*100/$value['sum_of_raw_total_marks'],


                    'raw_obtain_marks_percentage' => $value['sum_of_obtain_raw_total_marks'] * 100 /
                        ($value['sum_of_raw_total_marks'] ? $value['sum_of_raw_total_marks'] : 1),
>>>>>>> master

                    'sum_of_obtain_raw_total_marks_only_passed_subject' => $this->mathValue($math_condition, $value['sum_of_obtain_raw_total_marks_only_passed_subject']),
                    'pass_subject_base_marks_percentage' => $value['pass_subject_base_marks_percentage'],
                    'total_marks_base_percentage' => $value['total_marks_base_percentage'],
                    'pass_subject_base_marks_grade' => $value['pass_subject_base_marks_grade'],
                    'total_marks_base_grade' => $value['total_marks_base_grade'],
                    'pass_subject_base_marks_point' => $value['pass_subject_base_marks_point'],
                    'total_marks_base_point' => $value['total_marks_base_point'],

                    'sum_of_obtain_total_marks_for_show' => $this->mathValue($math_condition, $value['sum_of_obtain_total_marks_for_show']),
                    'sum_of_obtain_total_percent_for_show' => $value['sum_of_obtain_total_percent_for_show'],

                    //                'result_detail'=>json_encode($value['subject_list']),
                    'table_header' => json_encode($exam_type_array_with_sort),
                    'site_individual_combine_subject_result_store_ids' => implode(',', $value['site_individual_combine_subject_result_store_ids']),
                    'site_id' => Session::get('SITE_ID'),
                ]);
            }
        }


        // rank genarate start
        //    $getUpdatedSiteStudentPrimaryResultDetail= SiteStudentPrimaryResultDetail::whereIn('student_history_id', $studentIdsList)
        //        ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        //        ->orderBy('gpa', 'desc')
        //        ->orderBy('sum_of_obtain_raw_total_marks', 'desc')
        //        ->get();

        //    $previous_gpa=0;
        //    $previous_marks=0;
        //    $count=1;

        //    foreach ($getUpdatedSiteStudentPrimaryResultDetail as $key => $value){

        //        if($key==0){
        //            $previous_gpa=$value->gpa;
        //            $previous_marks=$value->sum_of_obtain_raw_total_marks;
        //        }

        //        if($previous_gpa==$value->gpa){
        //            if($previous_marks==$value->sum_of_obtain_raw_total_marks){

        //                SiteStudentPrimaryResultDetail::where('id', $value->id)
        //                ->update([
        //                    'student_rank'=>$count,
        //                ]);


        //            }else{
        //                SiteStudentPrimaryResultDetail::where('id', $value->id)
        //                    ->update([
        //                        'student_rank'=>$count+1,
        //                    ]);
        //                $count++;
        //            }

        //        }else{
        //            SiteStudentPrimaryResultDetail::where('id', $value->id)
        //                ->update([
        //                    'student_rank'=>$count+1,
        //                ]);
        //            $count++;
        //        }

        //        $previous_gpa=$value->gpa;
        //        $previous_marks=$value->sum_of_obtain_raw_total_marks;
        //    }

        // rank genarate end

<<<<<<< HEAD
      //  $count_student=count($classAllStudentlist);
        $count_student=count($studentIdsList);
      //  dd($count_student);
        $completed_percent=ceil(count($generatedStudentIDs)*100/$count_student);
=======
        $count_student = count($classAllStudentlist);
        //  dd($count_student);
        $completed_percent = ceil(count($generatedStudentIDs) * 100 / $count_student);
>>>>>>> master


        if (count($tenStudentIDs) > 0) {

            return response()->json(
                [
                    'generatedStudentIDs' => $generatedStudentIDs,
                    'count_student' => $count_student,
                    'completed_percent' => $completed_percent,
                ]
            );

            //            return compact('generatedStudentlist', 'classAllStudentlist', 'generatedStudentIDs', 'tenStudentIDs');
        } else {
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }
    }

    private function studentMarkslist(
        $studentMarksList,
        $grade_list,
        $subject_condition_setting,
        $resultSettingList,
        $getStudentOptionalSubject,
        $academic_result_primary_type_id,
        $showTableBellowSubjectExamList,
        $OtherSubjectExamList,
        $math_condition
    ) {



        $academicExamType = AcademicExamType::get();

        $student_array = $this->examTypePassFailStatus($studentMarksList);



        $class_test_present_list = $resultSettingList->where('examination.name_key', 'classtest');
        if (count($class_test_present_list) > 0) {
            $classtest_is_present = 1;
        } else {
            $classtest_is_present = 0;
        }

        //    $exam_percentage_sum=$resultSettingList->sum('marks_percentage');


        $student_history_all_ids = collect($student_array)->pluck('student_history_id');
        $student_history_ids = $student_history_all_ids->unique()->filter();


        $site_subject_examination_marks_all_ids = collect($student_array)->pluck('site_subject_group_condition_setting_id');
        $site_subject_examination_marks_ids = $site_subject_examination_marks_all_ids->unique()->filter();

        $site_subject_examination_marks_list = SiteSubjectExaminationMark::whereIn('site_subject_group_condition_setting_id', $site_subject_examination_marks_ids)
            ->where('status', true)
            ->get(['id', 'site_subject_group_condition_setting_id', 'examination_id', 'marks', 'pass_marks']);


        $siteIndividualCombineSubjectStudentList = SiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $academic_result_primary_type_id)
            ->whereIn('student_history_id', $student_history_ids)
            ->get();


        $student_list_arr = array();
        $student_list_array = [];
        $studentr_count = 0;
        foreach ($student_history_ids as $key => $value) {

            $student_optional_present_check = collect($getStudentOptionalSubject)->where('id', $value)->first();


            $student_exam_number_list = collect($student_array)->where('student_history_id', $value);
            $site_subject_group_condition_setting_all_id = collect($student_array)->where('student_history_id', $value)
                ->pluck('site_subject_group_condition_setting_id');
            $site_subject_group_condition_setting_ids = $site_subject_group_condition_setting_all_id->unique()->filter()->values();

            $examination_ids = $student_exam_number_list
                ->pluck('examination_id')->unique()->filter();

            $individual_subject_entry = [];
            $subject_arr = array();
            $subject_array = [];
            $keye_count = 0;

            foreach ($site_subject_group_condition_setting_ids as $keye => $valuee) {


                $examination_List = $student_exam_number_list
                    ->where('site_subject_group_condition_setting_id', $valuee);

                $student_exam_subject_attendance = $examination_List
                    ->where('exam_attendance_status', true)
                    ->first();

                if ($student_exam_subject_attendance) {
                    $student_exam_subject_attendance_status = true;
                } else {
                    $student_exam_subject_attendance_status = false;
                }

                $subject_base_pass_fail_list = $site_subject_examination_marks_list
                    ->where('site_subject_group_condition_setting_id', $valuee);

                $selected_subject_list = SubjectGroupConditionSetting::where('id', $valuee)->first();


                $exam_type_arr = array();
                $exam_type_array = [];

                foreach ($examination_ids as $keys => $values) {

                    $exam_setting_list = $resultSettingList->where('examination_id', $values)->first();


                    if ($selected_subject_list->result_show_in_table_bellow == 0) {


                        $used_academic_exam_type_ids = $OtherSubjectExamList
                            // ->where('examination_id', $values)
                            ->pluck('academic_exam_type_id')->unique()->filter();
                        $used_academic_exam_type_list = $academicExamType->whereIn('id', $used_academic_exam_type_ids);



                        $all_exam_type_arr = array();
                        $all_exam_type_array = [];


                        foreach ($used_academic_exam_type_list as $keystt => $valuestt) {

                            $check_exam_type = $examination_List
                                ->where('examination_id', $values)
                                ->where('academic_exam_type_id', $valuestt->id)->first();

                            //     dd($check_exam_type);

                            if ($check_exam_type) {
                                $all_exam_type_arr['academic_exam_type_id'] = $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name'] = $valuestt->marks_type;
                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = $check_exam_type['id'];
                                $all_exam_type_arr['row_obtaine_marks'] = $check_exam_type['obtaine_marks'];
                                //==== this condition add for exam type countable mark
                                //    dd($check_exam_type['exam_type_countable_marks_status']);
                                if ($check_exam_type['exam_type_countable_marks_status']) {
                                    $countable_obtain_marks = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['obtaine_marks'];
                                    $countable_pass_mark = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['pass_mark'];

                                    //   $all_exam_type_arr['obtaine_marks']= $this->mathValue($math_condition,$countable_obtain_marks);
                                    //   $all_exam_type_arr['pass_mark']= $this->mathValue($math_condition,$countable_pass_mark);


                                    if ($exam_setting_list->marks_percentage) {
                                        $percent_obtaine = ($countable_obtain_marks * $exam_setting_list->marks_percentage) / 100;
                                        $percent_pass_mark = ($countable_pass_mark * $exam_setting_list->marks_percentage) / 100;

                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $percent_obtaine);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $percent_pass_mark);
                                    } else {
                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $countable_obtain_marks);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $countable_pass_mark);
                                    }
                                } else {

                                    //   $all_exam_type_arr['pass_mark']= $check_exam_type['pass_mark'];
                                    //    $all_exam_type_arr['obtaine_marks']= $check_exam_type['obtaine_marks'];

                                    if ($exam_setting_list->marks_percentage) {
                                        $percent_obtaine = ($check_exam_type['obtaine_marks'] * $exam_setting_list->marks_percentage) / 100;
                                        $percent_pass_mark = ($check_exam_type['pass_mark'] * $exam_setting_list->marks_percentage) / 100;

                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $percent_obtaine);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $percent_pass_mark);
                                    } else {
                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $check_exam_type['obtaine_marks']);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $check_exam_type['pass_mark']);
                                    }
                                }

                                //  dd($all_exam_type_arr);

                                //====

                                if ($exam_setting_list->marks_percentage) {
                                    $percent_subject_exam_type_mark = ($check_exam_type['subject_exam_type_mark'] * $exam_setting_list->marks_percentage) / 100;

                                    $all_exam_type_arr['subject_exam_type_mark'] = $this->mathValue($math_condition, $percent_subject_exam_type_mark);
                                } else {
                                    $all_exam_type_arr['subject_exam_type_mark'] = $this->mathValue($math_condition, $check_exam_type['subject_exam_type_mark']);
                                }

                                //  $all_exam_type_arr['subject_exam_type_mark']= $check_exam_type['subject_exam_type_mark'];


                                $all_exam_type_arr['primary_pass_fail_status'] = $check_exam_type['primary_pass_fail_status'];

                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = $check_exam_type['site_subject_group_condition_setting_id'];
                                $all_exam_type_arr['student_history_id'] = $check_exam_type['student_history_id'];


                                $all_exam_type_arr['exam_type_countable_marks'] = $check_exam_type['exam_type_countable_marks'];



                                $all_exam_type_arr['exam_held_status']= $check_exam_type['exam_held_status'];
                                $all_exam_type_arr['exam_attendance_status']= $check_exam_type['exam_attendance_status'];
                                $all_exam_type_arr['exam_exist_status']= true;


                            }
                            else{
                                $all_exam_type_arr['academic_exam_type_id']= $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name']= $valuestt->marks_type;

                                $all_exam_type_arr['row_obtaine_marks']= 0;
                                $all_exam_type_arr['exam_type_countable_marks']= 0;

                                $all_exam_type_arr['examination_id']= $values;
                                $all_exam_type_arr['id']= 0;
                                $all_exam_type_arr['obtaine_marks']= 0;
                                $all_exam_type_arr['pass_mark']= 0;
                                $all_exam_type_arr['primary_pass_fail_status']= 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id']= 0;
                                $all_exam_type_arr['student_history_id']= 0;
                                $all_exam_type_arr['subject_exam_type_mark']= 0;
                                $all_exam_type_arr['exam_held_status']= false;
                                $all_exam_type_arr['exam_attendance_status']=false;
                                $all_exam_type_arr['exam_exist_status']= false;


                                $all_exam_type_arr['row_obtaine_marks'] = 0;

                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = 0;
                                $all_exam_type_arr['obtaine_marks'] = 0;
                                $all_exam_type_arr['pass_mark'] = 0;
                                $all_exam_type_arr['primary_pass_fail_status'] = 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = 0;
                                $all_exam_type_arr['student_history_id'] = 0;
                                $all_exam_type_arr['subject_exam_type_mark'] = 0;
                                $all_exam_type_arr['exam_held_status'] = false;
                                $all_exam_type_arr['exam_attendance_status'] = false;
                                $all_exam_type_arr['exam_exist_status'] = false;
                            }

                            $all_exam_type_array[$keystt] = array_merge($all_exam_type_arr);
                        }
                    } else {
                        $used_academic_exam_type_ids = $showTableBellowSubjectExamList->where('examination_id', $values)
                            ->pluck('academic_exam_type_id')->unique()->filter();
                        $used_academic_exam_type_list = $academicExamType->whereIn('id', $used_academic_exam_type_ids);



                        $all_exam_type_arr = array();
                        $all_exam_type_array = [];
                        foreach ($used_academic_exam_type_list as $keystt => $valuestt) {

                            $check_exam_type = $examination_List
                                ->where('examination_id', $values)
                                ->where('academic_exam_type_id', $valuestt->id)->first();


                            if ($check_exam_type) {
                                $all_exam_type_arr['academic_exam_type_id'] = $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name'] = $valuestt->marks_type;
                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = $check_exam_type['id'];
                                $all_exam_type_arr['row_obtaine_marks'] = $check_exam_type['obtaine_marks'];

                                //==== this condition add for exam type countable mark

                                if ($check_exam_type['exam_type_countable_marks_status']) {
                                    $countable_obtain_marks = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['obtaine_marks'];
                                    $countable_pass_mark = ($check_exam_type['exam_type_countable_persent_of_obtain_marks'] / 100) * $check_exam_type['pass_mark'];

                                    $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $countable_obtain_marks);
                                    $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $countable_pass_mark);


                                    if ($exam_setting_list->marks_percentage) {
                                        $percent_obtaine = ($countable_obtain_marks * $exam_setting_list->marks_percentage) / 100;
                                        $percent_pass_mark = ($countable_pass_mark * $exam_setting_list->marks_percentage) / 100;

                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $percent_obtaine);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $percent_pass_mark);
                                    } else {
                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $countable_obtain_marks);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $countable_pass_mark);
                                    }
                                } else {
                                    // $all_exam_type_arr['obtaine_marks']=$this->mathValue($math_condition,$check_exam_type['obtaine_marks']);
                                    // $all_exam_type_arr['pass_mark']= $check_exam_type['pass_mark'];

                                    if ($exam_setting_list->marks_percentage) {
                                        $percent_obtaine = ($check_exam_type['obtaine_marks'] * $exam_setting_list->marks_percentage) / 100;
                                        $percent_pass_mark = ($check_exam_type['pass_mark'] * $exam_setting_list->marks_percentage) / 100;

                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $percent_obtaine);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $percent_pass_mark);
                                    } else {
                                        $all_exam_type_arr['obtaine_marks'] = $this->mathValue($math_condition, $check_exam_type['obtaine_marks']);
                                        $all_exam_type_arr['pass_mark'] = $this->mathValue($math_condition, $check_exam_type['pass_mark']);
                                    }
                                }

                                if ($exam_setting_list->marks_percentage) {
                                    $percent_subject_exam_type_mark = ($check_exam_type['subject_exam_type_mark'] * $exam_setting_list->marks_percentage) / 100;

                                    $all_exam_type_arr['subject_exam_type_mark'] = $this->mathValue($math_condition, $percent_subject_exam_type_mark);
                                } else {
                                    $all_exam_type_arr['subject_exam_type_mark'] = $this->mathValue($math_condition, $check_exam_type['subject_exam_type_mark']);
                                }
                                //====


                               $all_exam_type_arr['exam_type_countable_marks']= $check_exam_type['exam_type_countable_marks'];

                                $all_exam_type_arr['primary_pass_fail_status']= $check_exam_type['primary_pass_fail_status'];

                                $all_exam_type_arr['site_subject_group_condition_setting_id']= $check_exam_type['site_subject_group_condition_setting_id'];
                                $all_exam_type_arr['student_history_id']= $check_exam_type['student_history_id'];
                             //   $all_exam_type_arr['subject_exam_type_mark']= $check_exam_type['subject_exam_type_mark'];
                                $all_exam_type_arr['exam_exist_status']= true;
                                $all_exam_type_arr['exam_held_status']= true;
                                $all_exam_type_arr['exam_attendance_status']=true;




                            }
                            else{
                                $all_exam_type_arr['academic_exam_type_id']= $valuestt->id;
                                $all_exam_type_arr['academic_exam_type_name']= $valuestt->marks_type;
                                $all_exam_type_arr['exam_type_countable_marks']= 0;

                                $all_exam_type_arr['row_obtaine_marks']= 0;

                                $all_exam_type_arr['examination_id']= $values;
                                $all_exam_type_arr['id']= 0;
                                $all_exam_type_arr['obtaine_marks']= 0;
                                $all_exam_type_arr['pass_mark']= 0;
                                $all_exam_type_arr['primary_pass_fail_status']= 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id']= 0;
                                $all_exam_type_arr['student_history_id']= 0;
                                $all_exam_type_arr['subject_exam_type_mark']= 0;
                                $all_exam_type_arr['exam_exist_status']= false;
                                $all_exam_type_arr['exam_held_status']= false;
                                $all_exam_type_arr['exam_attendance_status']=false;


                                $all_exam_type_arr['row_obtaine_marks'] = 0;

                                $all_exam_type_arr['examination_id'] = $values;
                                $all_exam_type_arr['id'] = 0;
                                $all_exam_type_arr['obtaine_marks'] = 0;
                                $all_exam_type_arr['pass_mark'] = 0;
                                $all_exam_type_arr['primary_pass_fail_status'] = 1;
                                $all_exam_type_arr['site_subject_group_condition_setting_id'] = 0;
                                $all_exam_type_arr['student_history_id'] = 0;
                                $all_exam_type_arr['subject_exam_type_mark'] = 0;
                                $all_exam_type_arr['exam_exist_status'] = false;
                                $all_exam_type_arr['exam_held_status'] = false;
                                $all_exam_type_arr['exam_attendance_status'] = false;
                            }

                            $all_exam_type_array[$keystt] = array_merge($all_exam_type_arr);
                        }
                    }


                  //  $exam_setting_list=$resultSettingList->where('examination_id', $values)->first();

                    $examination_base_pass_fail = $subject_base_pass_fail_list->where('examination_id', $values)
                        ->first();

                    $exam_type_all_ids = $examination_List
                        ->where('examination_id', $values)
                        ->pluck('academic_exam_type_id')->unique()->filter();


                    $row_subject_exam_type_mark = collect($all_exam_type_array)
                        ->sum('subject_exam_type_mark');

                    $exam_type_countable_marks=collect($all_exam_type_array)
                        ->sum('exam_type_countable_marks');


                    $subject_exam_type_pass_mark = collect($all_exam_type_array)
                        ->sum('pass_mark');

                    $exam_type_sum = collect($all_exam_type_array)
                        ->sum('obtaine_marks');

                    $row_obtaine_total_marks = collect($all_exam_type_array)
                        ->sum('row_obtaine_marks');

                    $find_term_exam_unheld_list = $examination_List
                        ->where('examination.name_key', 'termexam')
                        ->first();

                    $find_class_test_unheld_list = $examination_List
                        ->where('examination.name_key', 'classtest')
                        ->where('exam_held_status', true)
                        ->pluck('examination_id')
                        ->unique();

                    $find_class_test_unheld_list = $examination_List
                        ->where('exam_held_status', true)
                        ->unique();

                    $find_class_test_unheld_percentage = $resultSettingList
                        ->where('examination.name_key', 'classtest')
                        ->whereNotIn('examination_id', $find_class_test_unheld_list)
                        ->sum('marks_percentage');



                    if (
                        $find_class_test_unheld_percentage > 0 &&
                        $find_term_exam_unheld_list['examination_id'] == $exam_setting_list->examination_id
                    ) {

                        $class_test_percentage_with_term_exam = $exam_setting_list->marks_percentage +
                            $find_class_test_unheld_percentage;
                    } else {
                        $class_test_percentage_with_term_exam = $exam_setting_list->marks_percentage;
                    }

                    if ($exam_setting_list->marks_percentage && $examination_base_pass_fail) {

                        $countable_dependent_obtain_exam_type_marks_for_show = ($exam_type_sum * $exam_setting_list->marks_percentage) / 100;
                        $countable_dependent_obtain_exam_type_marks = ($exam_type_sum * $exam_setting_list->marks_percentage) / 100;
                    } else {

                        $countable_dependent_obtain_exam_type_marks = $exam_type_sum;
                        $countable_dependent_obtain_exam_type_marks_for_show = $exam_type_sum;
                    }
                    // dd($countable_dependent_obtain_exam_type_marks,$countable_dependent_obtain_exam_type_marks_for_show);
                    //                    Log::info($countable_dependent_obtain_exam_type_marks);

                    $exam_type_indivisula_pass_count = $examination_List
                        ->where('examination_id', $values)
                        ->sum('primary_pass_fail_status');

                    $exam_type = collect($all_exam_type_array)
                        ->where('examination_id', $values);


                    if (count($exam_type_all_ids) == $exam_type_indivisula_pass_count) {
                        $subject_indivisual_pass_fail_status = 1;
                    } else {
                        $subject_indivisual_pass_fail_status = 0;
                    }



                    $check_exam_held = $examination_List
                        ->where('examination_id', $values)
                        ->where('exam_held', 1)
                        ->first();
                    if ($check_exam_held) {
                        $exam_held_status = $check_exam_held['exam_held'];
                    } else {
                        $exam_held_status = 0;
                    }

                    $exam_type_arr['examination_id'] = $values;
                    $exam_type_arr['id'] = $exam_setting_list->show_position;

                    $exam_type_arr['examination_marks'] = $this->mathValue($math_condition, $row_subject_exam_type_mark);
                    //    $exam_type_arr['examination_marks']=$examination_base_pass_fail?$examination_base_pass_fail->marks:0;
                    $exam_type_arr['examination_pass_marks'] = $this->mathValue($math_condition, $subject_exam_type_pass_mark);
                    //    $exam_type_arr['examination_pass_marks']=$examination_base_pass_fail?$examination_base_pass_fail->pass_marks:0;

                    $exam_type_arr['subject_indivisual_pass_fail_status']=$subject_indivisual_pass_fail_status;
                    $exam_type_arr['exam_type_list']=collect($exam_type)->values();
                    $exam_type_arr['obtaine_total_marks']=$this->mathValue($math_condition,$exam_type_sum);
                    $exam_type_arr['row_subject_exam_type_mark']=$this->mathValue($math_condition,$row_subject_exam_type_mark);
                    $exam_type_arr['examination_countable_marks']=$this->mathValue($math_condition,$exam_type_countable_marks);
                    $exam_type_arr['row_obtaine_total_marks']= $this->mathValue($math_condition,$row_obtaine_total_marks);
                    $exam_type_arr['exam_held_status']=$exam_held_status;


                    $exam_type_arr['examination_name'] = $exam_setting_list->examination->examination_name;
                    $exam_type_arr['examination_name_key'] = $exam_setting_list->examination->name_key;
                    $exam_type_arr['marks_percentage'] = $exam_setting_list->marks_percentage;
                    //  $exam_type_arr['percentage_obtaine_marks']=$this->mathValue($math_condition,$percentage_obtaine_marks);

                    $exam_type_arr['show_position'] = $exam_setting_list->show_position;

                    $exam_type_arr['countable_dependent_obtain_exam_type_marks'] = $countable_dependent_obtain_exam_type_marks;
                    $exam_type_arr['countable_dependent_obtain_exam_type_marks_for_show'] = $this->mathValue($math_condition, $countable_dependent_obtain_exam_type_marks_for_show);

                    $exam_type_array[$keye_count] = array_merge($exam_type_arr);
                    $keye_count++;
                }



                $row_subject_exam_type_mark_sum=collect($exam_type_array)->sum('row_subject_exam_type_mark');
                $examination_countable_marks_sum=collect($exam_type_array)->sum('examination_countable_marks');
                $row_obtaine_total_marks_sum=collect($exam_type_array)->sum('row_obtaine_total_marks');


                $term_exam_obtaine_total_marks_sum = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('obtaine_total_marks');

                $term_exam_marks_percentage_sum = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('marks_percentage');

                $term_exam_obtaine_total_marks_sum = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('obtaine_total_marks');


                $term_exam_obtaine_total_marks_sum_for_show = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');

                //                $term_exam_countable_dependent_obtain_exam_type_marks_sum=collect($exam_type_array)->where('examination_name_key', 'termexam')
                //                    ->sum('countable_dependent_obtain_exam_type_marks');

                $termexam_exam_held = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->where('exam_held_status', 1)->first();
                if ($termexam_exam_held) {
                    $termexam_exam_held_status = $termexam_exam_held['exam_held_status'];
                } else {
                    $termexam_exam_held_status = 0;
                }

                $term_examination_marks_sum = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_marks');

                $term_examination_pass_marks_sum = collect($exam_type_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_pass_marks');


                $term_pass_fail_primary_status = $term_exam_obtaine_total_marks_sum >= $term_examination_pass_marks_sum ? 1 : 0;

                $classtest_marks_percentage_sum = collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('marks_percentage');

                $classtest_obtaine_total_marks_sum = collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('obtaine_total_marks');

                $classtest_obtaine_total_marks_sum_for_show = collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');



                $classtest_exam_held = collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->where('exam_held_status', 1)->first();
                if ($classtest_exam_held) {
                    $classtest_exam_held_status = $classtest_exam_held['exam_held_status'];
                } else {
                    $classtest_exam_held_status = 0;
                }



                $classtest_examination_marks_sum = collect($exam_type_array)->where('examination_name_key', 'classtest')
                    ->sum('examination_marks');

                //                $classtest_examination_pass_marks_sum=collect($exam_type_array)->where('examination_name_key', 'classtest')
                //                    ->sum('examination_pass_marks');


                //                $classtest_fail_primary_status=$classtest_obtaine_total_marks_sum>=$classtest_examination_pass_marks_sum?1:0;


                $indivisual_pass_fail_check_depend_on_exam_type = collect($exam_type_array)
                    ->pluck('subject_indivisual_pass_fail_status')->unique();

                // dd($exam_type_array);

                if ($term_pass_fail_primary_status) {
                    if (count($indivisual_pass_fail_check_depend_on_exam_type) == 1) {
                        $subject_base_pass_fail_status = 1;
                    } else if (count($indivisual_pass_fail_check_depend_on_exam_type) == 2) {
                        $subject_base_pass_fail_status = 0;
                    }
                } else {
                    $subject_base_pass_fail_status = 0;
                }

                if ($classtest_obtaine_total_marks_sum <= 0 && !$classtest_exam_held_status) {

                    if ($term_exam_marks_percentage_sum <= 0) {
                        $obtain_total_marks_in_term_exam = $term_exam_obtaine_total_marks_sum;
                    } else {
                        $obtain_total_marks_in_term_exam = ($term_exam_obtaine_total_marks_sum * 100) / $term_examination_marks_sum;
                    }

                    $obtain_total_marks_in_class_test = 0;

                    $subject_arr['total_marks_in_term_exam'] = $term_examination_marks_sum;
                    $subject_arr['total_marks_in_class_test'] = 0;
                    $subject_arr['obtain_raw_total_marks_in_term_exam'] = $term_exam_obtaine_total_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_class_test'] = 0;



                    $subject_arr['obtain_total_marks_in_term_exam'] = $this->mathValue($math_condition, $obtain_total_marks_in_term_exam);
                    $subject_arr['obtain_total_marks_in_class_test'] = $obtain_total_marks_in_class_test;
                } else {

                    $obtain_total_marks_in_term_exam = $term_exam_obtaine_total_marks_sum;
                    $obtain_total_marks_in_class_test = $classtest_obtaine_total_marks_sum;



                    $subject_arr['total_marks_in_term_exam'] = $term_examination_marks_sum;
                    $subject_arr['total_marks_in_class_test'] = $classtest_examination_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_term_exam'] = $term_exam_obtaine_total_marks_sum;
                    $subject_arr['obtain_raw_total_marks_in_class_test'] = $classtest_obtaine_total_marks_sum;



                    $subject_arr['obtain_total_marks_in_term_exam'] = $this->mathValue($math_condition, $obtain_total_marks_in_term_exam);
                    $subject_arr['obtain_total_marks_in_class_test'] = $obtain_total_marks_in_class_test;
                }


                $subject_total_number = $obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test;



                $subject_arr['examination_countable_marks_sum']=$this->mathValue($math_condition,$examination_countable_marks_sum);
                $subject_arr['row_subject_exam_type_mark_sum']=$this->mathValue($math_condition,$row_subject_exam_type_mark_sum);
                $subject_arr['row_obtaine_total_marks_sum']= $this->mathValue($math_condition,$row_obtaine_total_marks_sum);


                $subject_arr['obtain_total_marks_in_term_exam_for_show'] = $this->mathValue($math_condition, $term_exam_obtaine_total_marks_sum_for_show);
                $subject_arr['obtain_total_marks_in_class_test_for_show'] = $this->mathValue($math_condition, $classtest_obtaine_total_marks_sum_for_show);

                $subject_arr['termexam_exam_held_status'] = $termexam_exam_held_status;
                $subject_arr['classtest_exam_held_status'] = $classtest_exam_held_status;

                $subject_arr['student_exam_subject_attendance_status'] = $student_exam_subject_attendance_status;

                //   dd($subject_base_pass_fail_status);
                $subject_arr['subject_base_pass_fail_status'] = $subject_base_pass_fail_status;
                $subject_arr['result_show_in_table_bellow'] = $selected_subject_list->result_show_in_table_bellow;
                $subject_arr['exam_type_wise_result_create'] = $selected_subject_list->exam_type_wise_result_create;



                $subject_arr['obtain_subject_total_marks'] = $this->mathValue($math_condition, $subject_total_number);

                $subject_arr['subject_code'] = $selected_subject_list->subject_code;

                $subject_arr['subject_name'] = $selected_subject_list->subject_name;
                $subject_arr['exam_dependent_academic_subject'] = $selected_subject_list->examDependentAcademicSubject->subject_name;
                $subject_arr['subject_exam_name_key'] = $selected_subject_list->academicSubjectClassExamCondition->name_key;
                $subject_arr['subject_exam_name'] = $selected_subject_list->academicSubjectClassExamCondition->name;
                $subject_arr['exam_dependent_academic_subject_id'] = $selected_subject_list->exam_dependent_academic_subject_id;


                $subject_arr['academic_subject_id'] = $selected_subject_list->academic_subject_id;
                $subject_arr['subject_position'] = $selected_subject_list->subject_position;

                $subject_arr['site_subject_group_condition_setting_id'] = $valuee;
                $subject_arr['examination_list'] = array_values(array_sort(collect($exam_type_array), function ($value) {
                    return $value['show_position'];
                }));
                $subject_arr['countable_subject_total'] = collect($exam_type_array)->sum('countable_dependent_obtain_exam_type_marks_for_show');



                if ($student_optional_present_check) {
                    $checkOptionalSubject = collect($student_optional_present_check->optional_subject_ids[0])

                        ->where('id', $selected_subject_list->academic_subject_id)->first();

                    if ($checkOptionalSubject) {

                        $subject_arr['optional_academic_subject_status'] = 1;
                    } else {
                        $subject_arr['optional_academic_subject_status'] = 0;
                    }
                }

                $subject_array[$keye] = array_merge($subject_arr);
            }


            //    dd($subject_array);

            $getPreviousAllSubjectStoreCombineListIds = $siteIndividualCombineSubjectStudentList
                ->where('student_history_id', $value)
                ->where('status', true)
                ->pluck('id')
                ->toArray();

            $subject_group_by_array = collect($subject_array)
                ->groupBy('exam_dependent_academic_subject_id')->values();



            $dependent_single_subject_arr = array();
            $dependent_single_subject_array = [];
            $count = 0;
            $individual_combine_subject_entry = [];
            $combine_subject_present = [];
            $stable_ids = [];

            // return $subject_group_by_array;

            foreach ($subject_group_by_array as $keyo => $valueo) {

                if (count($valueo) > 1) {
                    $exam_type_wise_result_create = $valueo[0]['exam_type_wise_result_create'];
                    $combine_subject_present[] = 1;
                } else {
                    $combine_subject_present[] = 0;
                    $exam_type_wise_result_create = false;
                }


                $subject_condition_setting_ids = collect($valueo)->pluck('site_subject_group_condition_setting_id');

                $examination_list_array = [];
                foreach ($valueo as $examinationValue) {

                    foreach ($examinationValue['examination_list'] as $examinationKeyt => $examinationValuet) {
                        $examination_list_array[] = $examinationValuet;
                    }
                }

                $dependent_subject_array = [];

                if (count($valueo) > 1) {

                    $dependent_subject_examination_ids = collect($examination_list_array)
                        ->pluck('examination_id')->unique()->filter();

                    $dependent_subject_arr = array();
                    $marks_percent_present_absent = [];
                    foreach ($dependent_subject_examination_ids as $keyExamination => $valueExamination) {

                        $exam_setting_lists = $resultSettingList->where('examination_id', $valueExamination)->first();

                        $get_only_dependent_subject_lists = collect($examination_list_array)
                            ->where('examination_id', $valueExamination);

                        //   dd($get_only_dependent_subject_lists);

                        $exam_type_list_array = [];
                        foreach ($get_only_dependent_subject_lists as $examValue) {

                            foreach ($examValue['exam_type_list'] as $examValuet) {
                                $exam_type_list_array[] = $examValuet;
                            }
                        }

                        $only_dependent_subject_exam_type_ids = collect($exam_type_list_array)
                            ->where('examination_id', $valueExamination)
                            ->where('exam_exist_status', true)
                            ->pluck('academic_exam_type_id')->unique()->filter();

                        $exam_type_list_array = collect($exam_type_list_array)
                            ->where('exam_exist_status', true);
                        $examtype_arr = array();
                        $examtype_array = [];
                        foreach ($used_academic_exam_type_ids as $keyExamtype => $valueExamtype) {
                            $only_dependent_exam_type_lists = $exam_type_list_array
                                ->where('academic_exam_type_id', $valueExamtype);

                            if (count($only_dependent_exam_type_lists) > 0) {

                                $only_dependent_exam_type_marks_sum = $only_dependent_exam_type_lists
                                    ->sum('subject_exam_type_mark');

                                $only_dependent_exam_pass_mark_sum = $only_dependent_exam_type_lists
                                    ->sum('pass_mark');
                                $only_dependent_exam_type_obtaine_marks_sum = $only_dependent_exam_type_lists
                                    ->sum('obtaine_marks');

                                $count_dependent_exam_type_pass_fail = $only_dependent_exam_type_lists
                                    ->where('primary_pass_fail_status', 1);

                                //  $dependent_exam_pass_fail_status=$only_dependent_exam_type_obtaine_marks_sum>=$only_dependent_exam_pass_mark_sum?1:0;
                                // $dependent_exam_pass_fail_status=count($only_dependent_exam_type_lists)==count($count_dependent_exam_type_pass_fail)?1:0;

                                $countConbineSubjectType = count($only_dependent_exam_type_lists);
                                $com_average_exam_type_pass_mark = $only_dependent_exam_pass_mark_sum / $countConbineSubjectType;
                                $com_average_exam_type_obtain_mark = $only_dependent_exam_type_obtaine_marks_sum / $countConbineSubjectType;

                                if ($exam_type_wise_result_create) {
                                    $dependent_exam_pass_fail_status = $com_average_exam_type_obtain_mark >= $com_average_exam_type_pass_mark ? 1 : 0;
                                } else {
                                    $dependent_exam_pass_fail_status = count($only_dependent_exam_type_lists) == count($count_dependent_exam_type_pass_fail) ? 1 : 0;
                                }
                                $get_academic_exam_type_name_list = $only_dependent_exam_type_lists->first();

                                $row_subject_exam_type_mark = $only_dependent_exam_type_lists->sum('row_subject_exam_type_mark');
                                $row_obtaine_total_marks = $only_dependent_exam_type_lists->sum('row_obtaine_total_marks');

                                $examtype_arr['row_subject_exam_type_mark'] = $row_subject_exam_type_mark;
                                $examtype_arr['row_obtaine_total_marks'] = $row_obtaine_total_marks;
                                $examtype_arr['examination_id'] = $valueExamination;
                                $examtype_arr['academic_exam_type_id'] = $valueExamtype;
                                $examtype_arr['academic_exam_type_name'] = $get_academic_exam_type_name_list['academic_exam_type_name'];
                                $examtype_arr['pass_mark'] = $only_dependent_exam_pass_mark_sum;
                                $examtype_arr['subject_exam_type_mark'] = $only_dependent_exam_type_marks_sum;
                                $examtype_arr['obtaine_marks'] = $this->mathValue($math_condition, $only_dependent_exam_type_obtaine_marks_sum);
                                $examtype_arr['primary_pass_fail_status'] = $dependent_exam_pass_fail_status;

                                $examtype_arr['exam_held_status'] = true;
                            } else {
                                $examtype_arr['examination_id'] = null;
                                $examtype_arr['academic_exam_type_id'] = $valueExamtype;
                                $examtype_arr['academic_exam_type_name'] = '';
                                $examtype_arr['pass_mark'] = null;
                                $examtype_arr['subject_exam_type_mark'] = null;
                                $examtype_arr['obtaine_marks'] = null;
                                $examtype_arr['primary_pass_fail_status'] = null;

                                $examtype_arr['exam_held_status'] = true;
                            }



                            $examtype_array[$keyExamtype] = array_merge($examtype_arr);
                        }


                        $dependent_exam_type_list = collect($examtype_array)->where('examination_id', $valueExamination);

                        // dd($dependent_exam_type_list);

                        $dependent_exam_type_marks_sum = $dependent_exam_type_list
                            ->sum('subject_exam_type_mark');

                        $dependent_exam_pass_mark_sum = $dependent_exam_type_list
                            ->sum('pass_mark');
                        $dependent_exam_type_obtaine_marks_sum = $dependent_exam_type_list
                            ->sum('obtaine_marks');
                        $dependent_exam_pass_fail_status_sum = $dependent_exam_type_list
                            ->sum('primary_pass_fail_status');

                        //   dd($dependent_exam_type_list);



                        $dependent_exam_type_obtaine_marks_sum_for_show_arr = [];
                        foreach ($valueo as $keyObtMarks => $valueObtMarks) {

                            $dependent_exam_type_obtaine_marks_sum_for_show_arr[$keyObtMarks] = collect($valueObtMarks['examination_list'])
                                ->where('examination_id', $valueExamination)
                                ->sum('countable_dependent_obtain_exam_type_marks_for_show');
                        }
                        $dependent_exam_type_obtaine_marks_sum_for_show = array_sum($dependent_exam_type_obtaine_marks_sum_for_show_arr);

                        if ($exam_setting_lists->marks_percentage) {
                            $countable_dependent_obtain_exam_type_marks = ($dependent_exam_type_obtaine_marks_sum * $exam_setting_lists->marks_percentage) / 100;
                            // ($dependent_exam_type_marks_sum?$dependent_exam_type_marks_sum:1);

                        } else {
                            $countable_dependent_obtain_exam_type_marks = $dependent_exam_type_obtaine_marks_sum;
                        }

                        $check_combine_exam_held = collect($examination_list_array)
                            ->where('examination_id', $valueExamination)
                            ->where('exam_held', 1)
                            ->first();
                        if ($check_combine_exam_held) {
                            $exam_held_status = $check_exam_held['exam_held'];
                        } else {
                            $exam_held_status = 0;
                        }

                        $dependent_exam_setting_list = $resultSettingList->where('examination_id', $valueExamination)->first();

                        if (count($dependent_exam_type_list) == $dependent_exam_pass_fail_status_sum) {
                            $status_dependent_exam_pass_fail = 1;
                        } else {
                            $status_dependent_exam_pass_fail = 0;
                        }

                        $get_dependent_single_subject_list = $get_only_dependent_subject_lists->first();

                        //Log::info([count($examtype_array), $dependent_exam_pass_fail_status_sum]);

                        $dependent_subject_arr['exam_held_status'] = $exam_held_status;

                        $dependent_subject_arr['exam_type_list'] = collect($examtype_array);
                        $dependent_subject_arr['examination_id'] = $valueExamination;
                        $dependent_subject_arr['examination_name'] = $dependent_exam_setting_list->examination->examination_name;
                        $dependent_subject_arr['examination_marks'] = $dependent_exam_type_marks_sum;
                        $dependent_subject_arr['examination_name_key'] = $get_dependent_single_subject_list['examination_name_key'];
                        $dependent_subject_arr['examination_pass_marks'] = $dependent_exam_pass_mark_sum;
                        $dependent_subject_arr['marks_percentage'] = $dependent_exam_setting_list->marks_percentage;
                        $dependent_subject_arr['show_position'] = $dependent_exam_setting_list->show_position;
                        $dependent_subject_arr['obtaine_total_marks'] = $this->mathValue($math_condition, $dependent_exam_type_obtaine_marks_sum);
                        $dependent_subject_arr['subject_indivisual_pass_fail_status'] = $status_dependent_exam_pass_fail;
                        $dependent_subject_arr['countable_dependent_obtain_exam_type_marks'] = $this->mathValue($math_condition, $countable_dependent_obtain_exam_type_marks);
                        $dependent_subject_arr['countable_dependent_obtain_exam_type_marks_for_show'] = $this->mathValue($math_condition, $dependent_exam_type_obtaine_marks_sum_for_show);


                        $dependent_subject_array[$keyExamination] = array_merge($dependent_subject_arr);
                    }
                } else {
                    $dependent_subject_array = $valueo[0]['examination_list'];
                }

                $result_show_in_table_bellow_sum = $valueo->sum('result_show_in_table_bellow');
                $result_show_in_table_bellows = $result_show_in_table_bellow_sum / count($valueo);
                if ($result_show_in_table_bellows > 0) {
                    $result_show_in_table_bellow_status = 1;
                } else {
                    $result_show_in_table_bellow_status = 0;
                }



                if (count($valueo) > 1) {
                    $subject_code_array = collect($dependent_subject_array)->pluck('subject_code')->unique()->filter();


                    $subject_code = count($subject_code_array) > 0 ? implode(', ', $subject_code_array) : '';
                } else {
                    $subject_code = $valueo[0]['subject_code'];
                }



                $countable_dependent_obtain_termexam_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks');





                //                $dependent_termexam_exam_held=collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                //                    ->where('exam_held_status', 1)->first();
                //                if($dependent_termexam_exam_held){
                //                    $dependent_termexam_exam_held_status=$dependent_termexam_exam_held['exam_held_status'];
                //                }
                //                else{
                //                    $dependent_termexam_exam_held_status=0;
                //                }




                $dependent_row_subject_exam_type_mark_sum = collect($dependent_subject_array)->sum('row_subject_exam_type_mark');
                $dependent_row_obtaine_total_marks_sum = collect($dependent_subject_array)->sum('row_obtaine_total_marks');

                $dependent_term_exam_marks_percentage_sum = collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('marks_percentage');

                $dependent_term_exam_obtaine_total_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('obtaine_total_marks');


                $dependent_term_exam_obtaine_total_marks_sum_for_show = collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('countable_dependent_obtain_exam_type_marks_for_show');


                $dependent_term_examination_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_marks');

                $dependent_term_examination_pass_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'termexam')
                    ->sum('examination_pass_marks');

                $dependent_term_pass_fail_primary_status = $dependent_term_exam_obtaine_total_marks_sum >= $dependent_term_examination_pass_marks_sum ? 1 : 0;

                // subject_indivisual_pass_fail_status
                $countable_dependent_obtain_classtest_marks_sum = collect($dependent_subject_array)
                    ->where('examination_name_key', 'classtest')
                    ->sum('countable_dependent_obtain_exam_type_marks');

                $dependent_classtest_marks_percentage_sum = collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    //  ->where('countable_dependent_obtain_exam_type_marks', '!=', 0)
                    ->where('countable_dependent_obtain_exam_type_marks', '>=', 0)
                    ->sum('marks_percentage');



                $dependent_classtest_exam_held = collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->where('exam_held_status', 1)->first();
                if ($dependent_classtest_exam_held) {
                    $dependent_classtest_exam_held_status = $dependent_classtest_exam_held['exam_held_status'];
                } else {
                    $dependent_classtest_exam_held_status = 0;
                }

                // result show subject identify


                $dependent_classtest_obtaine_total_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('obtaine_total_marks');



                $dependent_classtest_obtaine_total_marks_sum_for_show = collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('obtaine_total_marks');



                $dependent_classtest_examination_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('examination_marks');

                $dependent_classtest_examination_pass_marks_sum = collect($dependent_subject_array)->where('examination_name_key', 'classtest')
                    ->sum('examination_pass_marks');


                //       $dependent_classtest_fail_primary_status=$dependent_classtest_obtaine_total_marks_sum>=$dependent_classtest_examination_pass_marks_sum?1:0;



                $exam_count = count(collect($dependent_subject_array)->pluck('examination_id'));

                $dependent_indivisual_pass_fail_check_depend_on_exam_type = collect($dependent_subject_array)
                    ->sum('subject_indivisual_pass_fail_status');

                //                Log::info($dependent_indivisual_pass_fail_check_depend_on_exam_type);



                $obtain_total_marks_for_show = collect($dependent_subject_array)
                    ->sum('obtaine_total_marks');

                $dependent_single_subject_arr['dependent_row_obtaine_total_marks_sum'] = $this->mathValue($math_condition, $dependent_row_obtaine_total_marks_sum);
                $dependent_single_subject_arr['dependent_row_subject_exam_type_mark_sum'] = $this->mathValue($math_condition, $dependent_row_subject_exam_type_mark_sum);

                $dependent_single_subject_arr['obtain_total_marks_in_term_exam_for_show'] = $this->mathValue($math_condition, $dependent_term_exam_obtaine_total_marks_sum_for_show);
                $dependent_single_subject_arr['obtain_total_marks_in_class_test_for_show'] = $this->mathValue($math_condition, $dependent_classtest_obtaine_total_marks_sum_for_show);
                $dependent_single_subject_arr['obtain_total_marks_for_show'] = $this->mathValue($math_condition, $obtain_total_marks_for_show);




                if ($dependent_term_pass_fail_primary_status) {
                    if ($exam_count == $dependent_indivisual_pass_fail_check_depend_on_exam_type) {
                        $dependent_subject_base_pass_fail_status = 1;
                    } else {
                        $dependent_subject_base_pass_fail_status = 0;
                    }
                } else {
                    $dependent_subject_base_pass_fail_status = 0;
                }


                $rest_percentage = 100 - ($dependent_term_exam_marks_percentage_sum + $dependent_classtest_marks_percentage_sum);

                if ($dependent_classtest_obtaine_total_marks_sum <= 0 && $dependent_classtest_exam_held_status == 0) {


                    if ($dependent_term_examination_marks_sum > 0) {

                        if ($dependent_term_exam_marks_percentage_sum > 0) {
                            $dependent_obtain_total_marks_in_term_exam = ($countable_dependent_obtain_termexam_marks_sum *
                                100) / $dependent_term_exam_marks_percentage_sum;
                        } else {
                            $dependent_obtain_total_marks_in_term_exam = $countable_dependent_obtain_termexam_marks_sum;
                        }
                    } else {
                        $dependent_obtain_total_marks_in_term_exam = 0;
                    }

                    $dependent_obtain_total_marks_in_class_test = 0;

                    ///   dd($dependent_obtain_total_marks_in_class_test);


                    $total_marks_in_term_exam = $dependent_term_examination_marks_sum;
                    $total_marks_in_class_test = 0;
                    $obtain_raw_total_marks_in_term_exam = $dependent_term_exam_obtaine_total_marks_sum;
                    $obtain_raw_total_marks_in_class_test = 0;
                    //                    $obtain_total_marks_in_term_exam=$dependent_obtain_total_marks_in_term_exam;
                    //                    $obtain_total_marks_in_class_test=$dependent_obtain_total_marks_in_class_test;



                    $dependent_single_subject_arr['total_marks_in_term_exam'] = $dependent_term_examination_marks_sum;
                    $dependent_single_subject_arr['total_marks_in_class_test'] = 0;
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_term_exam'] = $this->mathValue($math_condition, $dependent_term_exam_obtaine_total_marks_sum);
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_class_test'] = 0;



                    $dependent_single_subject_arr['obtain_total_marks_in_term_exam'] = $this->mathValue($math_condition, number_format((float)$dependent_obtain_total_marks_in_term_exam, 2, '.', ''));
                    $dependent_single_subject_arr['obtain_total_marks_in_class_test'] = $this->mathValue($math_condition, number_format((float)$dependent_obtain_total_marks_in_class_test, 2, '.', ''));
                } else {

                    if ($dependent_term_examination_marks_sum > 0) {

                        if ($dependent_term_exam_marks_percentage_sum > 0) {
                            $dependent_obtain_total_marks_in_term_exam = ($countable_dependent_obtain_termexam_marks_sum *
                                ($rest_percentage + $dependent_term_exam_marks_percentage_sum)) /
                                $dependent_term_exam_marks_percentage_sum;
                        } // 71.2*
                        else {
                            $dependent_obtain_total_marks_in_term_exam = $countable_dependent_obtain_termexam_marks_sum;
                        }
                    } else {
                        $dependent_obtain_total_marks_in_term_exam = 0;
                    }
                    //   dd($dependent_obtain_total_marks_in_term_exam);

                    $dependent_obtain_total_marks_in_class_test = $countable_dependent_obtain_classtest_marks_sum;

                    //  dd($countable_dependent_obtain_classtest_marks_sum);

                    $total_marks_in_term_exam = $dependent_term_examination_marks_sum;
                    $total_marks_in_class_test = $dependent_classtest_examination_marks_sum;
                    $obtain_raw_total_marks_in_term_exam = $this->mathValue($math_condition, $dependent_term_exam_obtaine_total_marks_sum);
                    $obtain_raw_total_marks_in_class_test = $this->mathValue($math_condition, $dependent_classtest_obtaine_total_marks_sum);

                    $dependent_single_subject_arr['total_marks_in_term_exam'] = $dependent_term_examination_marks_sum;
                    $dependent_single_subject_arr['total_marks_in_class_test'] = $dependent_classtest_examination_marks_sum;
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_term_exam'] = $this->mathValue($math_condition, $dependent_term_exam_obtaine_total_marks_sum);
                    $dependent_single_subject_arr['obtain_raw_total_marks_in_class_test'] = $this->mathValue($math_condition, $dependent_classtest_obtaine_total_marks_sum);
                    // dd($dependent_obtain_total_marks_in_term_exam);
                    $dependent_single_subject_arr['obtain_total_marks_in_term_exam'] = $this->mathValue($math_condition, number_format((float)$dependent_obtain_total_marks_in_term_exam, 2, '.', ''));
                    $dependent_single_subject_arr['obtain_total_marks_in_class_test'] = $this->mathValue($math_condition, number_format((float)$dependent_obtain_total_marks_in_class_test, 2, '.', ''));
                }

                if ($valueo[0]['subject_exam_name_key'] == 'onlyresultshow') {
                    $dependent_single_subject_arr['subject_result_count_status'] = false;
                } else {
                    $dependent_single_subject_arr['subject_result_count_status'] = true;
                }


                $dependent_single_subject_arr['obtain_raw_total_marks'] = $obtain_raw_total_marks_in_term_exam + $obtain_raw_total_marks_in_class_test;
                $dependent_single_subject_arr['obtain_percent_total_marks'] = $this->mathValue($math_condition, $obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test);
                // $dependent_single_subject_arr['obtain_percent_total_marks']=$obtain_total_marks_for_show;
                $dependent_single_subject_arr['raw_total_marks'] = $total_marks_in_term_exam + $total_marks_in_class_test;
                if ($dependent_obtain_total_marks_in_class_test > 0) {
                    $dependent_subject_total_number = $dependent_obtain_total_marks_in_term_exam +
                        $dependent_obtain_total_marks_in_class_test;
                } else {

                    if ($dependent_single_subject_arr['obtain_raw_total_marks'] > 0) {
                        $dependent_subject_total_number = $dependent_single_subject_arr['obtain_raw_total_marks'] * 100 /
                            $dependent_single_subject_arr['raw_total_marks'];
                    } else {
                        $dependent_subject_total_number = 0;
                    }
                }

                if($dependent_subject_total_number>100){
                    $dependent_subject_total_number=$dependent_single_subject_arr['obtain_raw_total_marks'];
                }

             //   dd($dependent_single_subject_arr);


                if ($dependent_subject_base_pass_fail_status == 1) {
                    $subject_grade_find = $grade_list
                        ->where('number_from', '<=', $this->mathValue($math_condition, $dependent_subject_total_number))
                        ->Where('number_to', '>=', $this->mathValue($math_condition, $dependent_subject_total_number))
                        ->first();
<<<<<<< HEAD

                    // $subject_grade_find=$grade_list
                    //     ->where('number_from', '<=', $this->mathValue($math_condition,$dependent_single_subject_arr['obtain_raw_total_marks']) )
                    //     ->Where('number_to', '>=', $this->mathValue($math_condition,$dependent_single_subject_arr['obtain_raw_total_marks']))
                    //     ->first();
                }else{
                    $subject_grade_find=$grade_list
                        ->where('number_from', '<=', $this->mathValue($math_condition,0) )
                        ->Where('number_to', '>=', $this->mathValue($math_condition,0))
                        ->first();
                }

                // if(!$subject_grade_find){
                //     $subject_grade_find=$grade_list
                //     ->where('number_from', '<=', 0)
                //     ->Where('number_to', '>=', 0)
                //     ->first();
                // }
=======
                } else {
                    $subject_grade_find = $grade_list
                        ->where('number_from', '<=', $this->mathValue($math_condition, 0))
                        ->Where('number_to', '>=', $this->mathValue($math_condition, 0))
                        ->first();
                }

                if (!$subject_grade_find) {
                    $subject_grade_find = $grade_list
                        ->where('number_from', '<=', 0)
                        ->Where('number_to', '>=', 0)
                        ->first();
                }
>>>>>>> master

                $find_first_data = collect($valueo)->first();

                $dependent_single_subject_arr['exam_dependent_academic_subject_id'] = $find_first_data['exam_dependent_academic_subject_id'];
                $dependent_single_subject_arr['subject_position'] = $find_first_data['subject_position'];
                $dependent_single_subject_arr['exam_dependent_academic_subject'] = $find_first_data['exam_dependent_academic_subject'];

                $dependent_single_subject_arr['subject_code'] = $subject_code;


                $optional_sub_check = collect($valueo)->pluck('optional_academic_subject_status')->unique()->filter();


                if (count($optional_sub_check) > 0) {

                    $dependent_single_subject_arr['dependent_optional_academic_subject_status'] = 1;

                    $dependent_single_subject_arr['subject_countable_point'] = $subject_grade_find ? $subject_grade_find->point > 2 ? ($subject_grade_find->point - 2) : 0 : 0;
                } else {
                    $dependent_single_subject_arr['dependent_optional_academic_subject_status'] = 0;

                    $dependent_single_subject_arr['subject_countable_point'] = $subject_grade_find ? $subject_grade_find->point : 0;
                }

                $dependent_single_subject_arr['result_show_in_table_bellow_status'] = $result_show_in_table_bellow_status;
                // $dependent_single_subject_arr['subject_base_pass_fail_status']=$dependent_subject_base_pass_fail_status;
                $dependent_single_subject_arr['subject_base_pass_fail_status'] = $subject_grade_find ? $subject_grade_find->pass_fail_status : 0;

                $dependent_single_subject_arr['obtain_subject_total_marks'] = floor($dependent_single_subject_arr['obtain_raw_total_marks']);

                $dependent_single_subject_arr['subject_marks_percentage'] = floor($dependent_subject_total_number);

                $dependent_single_subject_arr['subject_point'] = $subject_grade_find ? $subject_grade_find->point : 0;
                $dependent_single_subject_arr['subject_grade'] = $subject_grade_find ? $subject_grade_find->academicResultSystem->name : 0;
                $dependent_single_subject_arr['indivisual_student_subject_list'] = $valueo;
                $dependent_single_subject_arr['subject_count'] = count($valueo);
                $dependent_single_subject_arr['dependent_subject_list'] = array_values(array_sort(collect($dependent_subject_array), function ($value) {
                    return $value['show_position'];
                }));


                $tab_arr = array();
                $tab_array = [];
                foreach ($valueo as $keytp => $valuetp) {

                    $tab_exam_arr = array();
                    $tab_exam_array = [];


                    foreach ($valuetp['examination_list'] as $keytpt => $valuetpt) {

                        $tab_exam_arr['exam_type_list'] = $valuetpt['exam_type_list'];
                        $tab_exam_arr['examination_id'] = $valuetpt['examination_id'];
                        $tab_exam_arr['examination_name'] = $valuetpt['examination_name'];
                        $tab_exam_arr['obtaine_total_marks'] = $this->mathValue($math_condition, $valuetpt['obtaine_total_marks']);
                        $tab_exam_arr['examination_marks'] = $valuetpt['examination_marks'];
                        $tab_exam_arr['countable_dependent_obtain_exam_type_marks'] = $valuetpt['countable_dependent_obtain_exam_type_marks'];
                        // $tab_exam_arr['countable_dependent_obtain_exam_type_marks']=ceil($valuetpt['obtaine_total_marks']*($valuetpt['marks_percentage']/100));


                        $tab_exam_array[$keytpt] = array_merge($tab_exam_arr);
                    }
                    // ==extra add for percentage==
                    $countable_mark = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');
                    $tab_arr['countable_obtain_marks'] = $this->mathValue($math_condition, $countable_mark);

                    //===
                    $tab_arr['obtain_marks'] = $this->mathValue($math_condition, $valuetp['obtain_total_marks_in_term_exam'] + $valuetp['obtain_total_marks_in_class_test']);

                    $tab_arr['subject_name'] = $valuetp['subject_name'];
                    $tab_arr['academic_subject_id'] = $valuetp['academic_subject_id'];
                    $tab_arr['subject_base_pass_fail_status'] = $valuetp['subject_base_pass_fail_status'];
                    $tab_arr['examination_list'] = $tab_exam_array;

                    $tab_array[$keytp] = array_merge($tab_arr);
                }


                $dependent_single_subject_array[$count] = array_merge($dependent_single_subject_arr);
                $count++;

                $checkCombineSubjectIntable = $siteIndividualCombineSubjectStudentList->where('student_history_id', $value)
                    ->where('academic_result_primary_type_id', $academic_result_primary_type_id)
                    ->where('exam_dependent_academic_subject_id', $dependent_single_subject_arr['exam_dependent_academic_subject_id'])
                    ->first();

                $student_exam_combine_subject_attendance = collect($valueo)
                    ->where('student_exam_subject_attendance_status', true)
                    ->first();

                if ($student_exam_combine_subject_attendance) {
                    $student_exam_combine_subject_attendance_status = true;
                } else {
                    $student_exam_combine_subject_attendance_status = false;
                }



                if ($checkCombineSubjectIntable) {

                    $stable_ids[] = $checkCombineSubjectIntable->id;

                    //    $obtain = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');

                    $checkCombineSubjectIntable
                        ->update([
                            'subject_result_count_status' => $dependent_single_subject_arr['subject_result_count_status'],
                            'subject_base_pass_fail_status' => $dependent_subject_base_pass_fail_status,
                            'obtain_subject_total_marks' => $this->mathValue($math_condition, $dependent_single_subject_arr['obtain_subject_total_marks']),
                            'subject_marks_percentage' => $dependent_single_subject_arr['subject_marks_percentage'],
                            'subject_grade' => $dependent_single_subject_arr['subject_grade'],
                            'subject_point' => $dependent_single_subject_arr['subject_point'],
                            'exam_attendance_status' => $student_exam_combine_subject_attendance_status,
                            'subject_position' => $dependent_single_subject_arr['subject_position'],
                            'subject_count' => count($valueo),
                            'subject_detail' => json_encode($dependent_single_subject_arr),
                            'list_for_tabulation' => json_encode($tab_array),

                            'same_row_total_marks' => $dependent_single_subject_arr['dependent_row_subject_exam_type_mark_sum'],
                            'same_obtain_raw_total_marks' => $dependent_single_subject_arr['dependent_row_obtaine_total_marks_sum'],

                            'result_show_in_table_bellow_status' => $dependent_single_subject_arr['result_show_in_table_bellow_status'],
                            'updated_at' => Carbon::today(),
                            'obtain_raw_total_marks' => $this->mathValue($math_condition, $obtain_raw_total_marks_in_term_exam + $obtain_raw_total_marks_in_class_test),

                            'raw_total_marks' => $this->mathValue($math_condition, $dependent_single_subject_arr['raw_total_marks']),
                            'obtain_total_marks_for_show' => $obtain_total_marks_for_show,

                            'obtain_percent_total_marks' => $this->mathValue($math_condition, $obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test),
                            // 'obtain_percent_total_marks'=> $tab_array[0]['countable_obtain_marks'],
                            //  'obtain_percent_total_marks'=> ceil($obtain),
                        ]);
                    //                    }

                    //                    }


                } else {
                    $obtain = collect($tab_exam_array)->sum('countable_dependent_obtain_exam_type_marks');

                    $individual_combine_subject_entry[] = [
                        'student_history_id' => $value,
                        'academic_result_primary_type_id' => $academic_result_primary_type_id,
                        'exam_dependent_academic_subject_id' => $dependent_single_subject_arr['exam_dependent_academic_subject_id'],
                        'optional_academic_subject_status' => $dependent_single_subject_arr['dependent_optional_academic_subject_status'],
                        'subject_base_pass_fail_status' => $dependent_subject_base_pass_fail_status,
                        'subject_result_count_status' => $dependent_single_subject_arr['subject_result_count_status'],

                        'raw_total_marks' => $this->mathValue($math_condition, $dependent_single_subject_arr['raw_total_marks']),

                        'obtain_subject_total_marks' => $this->mathValue($math_condition, $dependent_single_subject_arr['obtain_subject_total_marks']),
                        'subject_marks_percentage' => $dependent_single_subject_arr['subject_marks_percentage'],
                        'subject_grade' => $dependent_single_subject_arr['subject_grade'],
                        'subject_position' => $dependent_single_subject_arr['subject_position'],
                        'exam_attendance_status' => $student_exam_combine_subject_attendance_status,

                        'same_row_total_marks' => $dependent_single_subject_arr['dependent_row_subject_exam_type_mark_sum'],
                        'same_obtain_raw_total_marks' => $dependent_single_subject_arr['dependent_row_obtaine_total_marks_sum'],

                        'result_show_in_table_bellow_status' => $dependent_single_subject_arr['result_show_in_table_bellow_status'],

                        'subject_point' => $dependent_single_subject_arr['subject_point'],
                        'subject_count' => count($valueo),
                        'subject_detail' => json_encode($dependent_single_subject_arr),

                        'list_for_tabulation' => json_encode($tab_array),

                        'status' => true,
                        'site_id' => Session::get('SITE_ID'),
                        'created_at' => Carbon::today(),

                        'obtain_total_marks_for_show' => $obtain_total_marks_for_show,

                        'obtain_raw_total_marks' => $this->mathValue($math_condition, $obtain_raw_total_marks_in_term_exam + $obtain_raw_total_marks_in_class_test),
                        'obtain_percent_total_marks' => $this->mathValue($math_condition, $obtain_total_marks_in_term_exam + $obtain_total_marks_in_class_test),

                        // 'obtain_percent_total_marks'=> $tab_array[0]['countable_obtain_marks'],
                        //  'countable_obtain_marks'=> $tab_array[0]['countable_obtain_marks'],

                        //'obtain_percent_total_marks'=> ceil($obtain_raw_total_marks_in_term_exam+$obtain_raw_total_marks_in_class_test),
                        //'total_exam_marks'=>$dependent_single_subject_arr['total_exam_marks'],
                        //'obtain_percent_total_marks'=> ceil($obtain),
                    ];
                }
            }


            if (count($getPreviousAllSubjectStoreCombineListIds) > 0) {
                if (count($stable_ids) > 0) {
                    $ids_for_delete = array_diff($getPreviousAllSubjectStoreCombineListIds, $stable_ids);
                    SiteIndividualCombineSubjectResultStore::whereIn('id', $ids_for_delete)->delete();
                }
            }


            if (count($individual_combine_subject_entry) > 0) {
                SiteIndividualCombineSubjectResultStore::insert($individual_combine_subject_entry);
            }

            $getlatestSubjectStoreCombineList = SiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $academic_result_primary_type_id)
                ->where('student_history_id', $value)
                ->where('status', true)
                ->orderBy('subject_position')
                ->get();

            //     dd($getlatestSubjectStoreCombineList);


            //            if($value==7940){
            //                return $getlatestSubjectStoreCombineList;
            //            }

            $full_exam_attendance_list = $getlatestSubjectStoreCombineList->where('exam_attendance_status', true)->first();


            if ($full_exam_attendance_list) {
                $full_exam_attendance_list_status = true;
            } else {
                $full_exam_attendance_list_status = false;
            }



            $getlatestSubjectStoreCombineIDs = $getlatestSubjectStoreCombineList->pluck('id');

            $subject_detail = [];
            $optional_subject_list = [];
            foreach ($getlatestSubjectStoreCombineList as $keyt => $valuet) {

                $subject_detail[] = $valuet->subject_detail;
                if ($valuet->optional_academic_subject_status == 1) {
                    $optional_subject_list[] = $valuet->exam_dependent_academic_subject_id;
                }
            }



            $sum_of_obtain_total_marks_for_show = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('obtain_total_marks_for_show');

            $sum_of_same_row_total_marks = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('same_row_total_marks');
            $sum_of_same_obtain_raw_total_marks = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('same_obtain_raw_total_marks');

            $sum_of_obtain_total_percent_for_show = collect($subject_detail)->where('subject_result_count_status', true)
                ->avg('subject_marks_percentage');

            $sum_of_obtain_raw_total_marks = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('obtain_raw_total_marks');
            $sum_of_obtain_percent_total_marks = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('obtain_percent_total_marks');
            $sum_of_raw_total_marks = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('raw_total_marks');
            //obtain_percent_total_marks

            $sum_of_total_point_with_optional = collect($subject_detail)->where('subject_result_count_status', true)
                ->sum('subject_countable_point');
            $sum_of_total_point_without_optional = collect($subject_detail)->where('subject_result_count_status', true)
                ->where('dependent_optional_academic_subject_status', 0)
                ->sum('subject_countable_point');
            $sum_of_total_countable_subject = collect($subject_detail)->where('subject_result_count_status', true)
                ->where('dependent_optional_academic_subject_status', 0)
                ->count('exam_dependent_academic_subject_id');
            $sum_of_subject_base_pass_fail_status = collect($subject_detail)->where('subject_result_count_status', true)
                ->where('dependent_optional_academic_subject_status', 0)
                ->sum('subject_base_pass_fail_status');

            //  dd(collect($subject_detail[0]));
            if ($sum_of_total_countable_subject == $sum_of_subject_base_pass_fail_status) {


                if ($sum_of_total_countable_subject <= 0) {
                    $student_final_point_with_optional = 0;
                    $student_final_point_without_optional = 0;
                } else {
                    $student_final_point_with_optional = ($sum_of_total_point_with_optional / $sum_of_total_countable_subject) > 5 ? 5 : ($sum_of_total_point_with_optional / $sum_of_total_countable_subject);

                    $student_final_point_without_optional = $sum_of_total_point_without_optional / $sum_of_total_countable_subject ?? 1;
                }
            } else {

                $student_final_point_with_optional = 0;
                $student_final_point_without_optional = 0;
            }

            //Log::info($student_final_point_with_optional);



            $total_grade_find = collect($grade_list)
                ->where('point_from', '<=', $student_final_point_with_optional)
                ->Where('point_to', '>=', $student_final_point_with_optional)
                ->first();


            $total_grade_find_without_optional = $grade_list
                ->where('point_from', '<=', $student_final_point_without_optional)
                ->Where('point_to', '>=', $student_final_point_without_optional)
                ->first();

            $academic_primary_id_get = collect($resultSettingList)->first();

            $multiple_subject_present = collect($combine_subject_present)->unique()->filter();
            //    $multiple_subject_present=$combine_subject_present;

            //=======================এইগুলো টেবিলে দিতে হবে।===================

            $sum_of_obtain_raw_total_marks_only_passed_subject = collect($subject_detail)->where('subject_result_count_status', true)
                ->where('subject_base_pass_fail_status', 1)
                ->sum('obtain_raw_total_marks');

            if ($sum_of_raw_total_marks <= 0) {
                $pass_subject_base_marks_percentage = 0;
                $total_marks_base_percentage = 0;
            } else {
                $pass_subject_base_marks_percentage = $sum_of_obtain_raw_total_marks_only_passed_subject * 100 /
                    $sum_of_raw_total_marks;

                $total_marks_base_percentage = $sum_of_obtain_raw_total_marks * 100 /
                    $sum_of_raw_total_marks;
            }


            $pass_subject_base_marks_grade = $grade_list
                ->where('number_from', '<=', $this->mathValue($math_condition, $pass_subject_base_marks_percentage))
                ->Where('number_to', '>=', $this->mathValue($math_condition, $pass_subject_base_marks_percentage))
                ->first();

            if (!$pass_subject_base_marks_grade) {
                $pass_subject_base_marks_grade = $grade_list
                    ->where('number_from', '<=', 0)
                    ->Where('number_to', '>=', 0)
                    ->first();
            }


            $total_marks_base_grade = $grade_list
                ->where('number_from', '<=', $this->mathValue($math_condition, $total_marks_base_percentage))
                ->Where('number_to', '>=', $this->mathValue($math_condition, $total_marks_base_percentage))
                ->first();


            $pass_subject_base_marks_point = $pass_subject_base_marks_grade->point;



            $total_marks_base_point = $total_marks_base_grade->point;


            $student_list_arr['sum_of_obtain_raw_total_marks_only_passed_subject'] = $this->mathValue($math_condition, $sum_of_obtain_raw_total_marks_only_passed_subject);
            $student_list_arr['pass_subject_base_marks_percentage'] = $pass_subject_base_marks_percentage;
            $student_list_arr['total_marks_base_percentage'] = $total_marks_base_percentage;
            $student_list_arr['pass_subject_base_marks_grade'] = $pass_subject_base_marks_grade->academicResultSystem->name;
            $student_list_arr['total_marks_base_grade'] = $total_marks_base_grade->academicResultSystem->name;
            $student_list_arr['pass_subject_base_marks_point'] = $pass_subject_base_marks_point;
            $student_list_arr['total_marks_base_point'] = $total_marks_base_point;

            $student_list_arr['exam_attendance_status'] = $full_exam_attendance_list_status;

            $student_list_arr['fail_subject_count'] = $sum_of_total_countable_subject - $sum_of_subject_base_pass_fail_status;
            $student_list_arr['academic_result_primary_type_id'] = $academic_primary_id_get->academicResultPrimaryType->id;
            $student_list_arr['final_grade'] = $total_grade_find->academicResultSystem->name ?? null;

            $student_list_arr['final_point'] = number_format((float)$student_final_point_with_optional, 2, '.', '');

            $student_list_arr['student_history_id'] = $value;
            $student_list_arr['subject_list'] = $subject_detail;
            $student_list_arr['site_individual_combine_subject_result_store_ids'] = $getlatestSubjectStoreCombineIDs->toArray();


            $student_list_arr['final_grade_without_optional'] = $total_grade_find_without_optional->academicResultSystem->name ?? null;
            $student_list_arr['final_point_without_optional'] = number_format((float)$student_final_point_without_optional, 2, '.', '');
            $student_list_arr['optional_subject_ids'] = implode(',', $optional_subject_list);
            $student_list_arr['combine_subject_present'] = count($multiple_subject_present) >= 1 ? 1 : 0;;
            $student_list_arr['classtest_is_present'] = $classtest_is_present;

            $student_list_arr['sum_of_obtain_total_marks_for_show'] = $this->mathValue($math_condition, $sum_of_obtain_total_marks_for_show);
            $student_list_arr['sum_of_obtain_total_percent_for_show'] = number_format((float)$sum_of_obtain_total_percent_for_show, 2, '.', '');

            $student_list_arr['sum_of_obtain_raw_total_marks'] = $this->mathValue($math_condition, $sum_of_obtain_raw_total_marks);
            $student_list_arr['sum_of_obtain_percent_total_marks'] = $sum_of_obtain_percent_total_marks;
            $student_list_arr['sum_of_raw_total_marks'] = $sum_of_raw_total_marks;

            $student_list_arr['sum_of_same_row_total_marks'] = $sum_of_same_row_total_marks;
            $student_list_arr['sum_of_same_obtain_raw_total_marks'] = $sum_of_same_obtain_raw_total_marks;

            $student_list_array[$studentr_count] = array_merge($student_list_arr);
            $studentr_count++;
        }

        //  dd($student_list_array);

        return $student_list_array;
    }



    private function examTypePassFailStatus($studentMarksList)
    {

        $student_arr = array();
        $student_array = [];
        foreach ($studentMarksList as $key => $value) {

            if ($value->exam_held_status) {

                if ($value->exam_attendance_status) {

                    if ($value->obtaine_marks >= $value->pass_mark) {

                        $student_arr['primary_pass_fail_status'] = 1;
                        $student_arr['exam_held'] = 1;
                    } else {
                        $student_arr['primary_pass_fail_status'] = 0;
                        $student_arr['exam_held'] = 1;
                    }
                } else {
                    $student_arr['primary_pass_fail_status'] = 0;
                    $student_arr['exam_held'] = 1;
                    $student_arr['is_countable_mark'] = 1;
                }
            } else {
                $student_arr['primary_pass_fail_status'] = 1;
                $student_arr['exam_held'] = 0;
            }
            $student_array[$key] = array_merge($student_arr, $value->toArray());
        }

        return $student_array;
    }


    public function publishPauseResultToEmployeeStudentPanel(Request $request)
    {

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            //                ->where('status', true)
            ->pluck('id');

        // dd($request->all());

        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->update([
                'result_employee_publish_status' => $request->result_employee_publish_status,
                'result_student_publish_status' => $request->result_student_publish_status,
                'result_public_publish_status' => $request->result_public_publish_status,
            ]);


        if ($request->result_employee_publish_status && $request->result_student_publish_status) {
            return Response::json(['message' => 'Result Published to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        } else if (!$request->result_employee_publish_status && $request->result_student_publish_status) {
            return Response::json(['message' => 'Result Pause to Employee & Published to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        } else if ($request->result_employee_publish_status && !$request->result_student_publish_status) {
            return Response::json(['message' => 'Result Published to Employee & Pause to Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        } else if (!$request->result_employee_publish_status && !$request->result_student_publish_status) {
            return Response::json(['message' => 'Result Pause to Employee & Student Panel Successfully!', 'mode' => 'Saved!'], 200);
        } else if ($request->result_public_publish_status) {
            return Response::json(['message' => 'Result Published to public', 'mode' => 'Saved!'], 200);
        } else if (!$$request->result_public_publish_status) {
            return Response::json(['message' => 'Result Pause to public', 'mode' => 'Saved!'], 200);
        }
    }


    public function deleteResultToEmployeeStudentPanel(Request $request)
    {

        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            //                ->where('status', true)
            ->pluck('id');



        SiteIndividualCombineSubjectResultStore::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->delete();




        SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->delete();
        return Response::json(['message' => 'Result Deleted Successfully!', 'mode' => 'delete!'], 200);
    }


    private function getStudenthistoryList(Request $request)
    {


        $data = $request->all();
        $studentList = StudentHistory::select('id', 'user_id', 'student_roll_number', 'site_batch_detail_id')
            ->with([
                'student' => function ($q) {
                    $q->with('latestPhoto');
                    $q->select('id');
                    $q->where('user_type', 'student');
                },
                'year',
                'shift',
                'department',
                'batch',
                'stClass',
                'classGroup',
                'session',
                'section'
            ])
            ->where('academic_version_id', $request->academic_version_id)
            ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                return $query->where('academic_shift_id', $data['academic_shift_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['site_batch_detail_id']), function ($query) use ($data) {
                return $query->where('site_batch_detail_id', $data['site_batch_detail_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            // ->when(!empty($data['status']), function ($query) use ($data) {
            //     return $query->where('status', $data['status']);
            // })
            //->where('status',true)
            ->orderBy('student_roll_number')
            ->orderBy('academic_section_id')
            ->orderBy('academic_class_id')
            ->orderBy('academic_department_id')
            ->orderBy('site_batch_detail_id')
            ->orderBy('academic_class_group_id')
            ->get();

        //    dd($studentList);
        return $studentList;
    }



    public function getStudentResultList(Request $request)
    {


        try {

            $studentList = $this->getStudenthistoryList($request);
            $student_ids = $studentList->pluck('id');
            $placeholders = implode(',', array_fill(0, count($student_ids), '?'));

              $perfomance_list = SiteStudentPrimaryResultDetail::with(['studentHistory' => function ($q) {
                $q->with(['student' => function ($q2) {
                    $q2->select('id');
                }]);
                // ->select('id', 'user_id', 'student_roll_number', 'student_roll_number_prefix')
            }, 'academicResultPrimaryType'])
                ->whereIn('student_history_id', $student_ids)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->select(
                    'id',
                    'student_history_id',
                    'academic_result_primary_type_id',
                    'academic_days',
                    'present_days',
                    'comment',
                    'absent_days',
                    'behaviour',
                    'cultural_activities',
                    'bncc',
                    'grade',
                    'debate',
                    'scout',
                    'sports',
                    'others'
                )
                ->orderByRaw("field(student_history_id,{$placeholders})", $student_ids)
                ->get();


            $performance_array = [];
            $key = 0;
            foreach ($perfomance_list as $item) {

                $performance_array[$key]['id'] = $item->id;
                $performance_array[$key]['student_history_id'] = $item->student_history_id;
                $performance_array[$key]['student_name'] = $item->studentHistory->full_name;
                $performance_array[$key]['student_full_roll_number'] = $item->studentHistory->student_full_roll_number;
                $performance_array[$key]['academic_result_primary_type'] = $item->academicResultPrimaryType ? $item->academicResultPrimaryType->name : '';;
                $performance_array[$key]['academic_result_primary_type_id'] = $item->academic_result_primary_type_id;
                $performance_array[$key]['comment'] = $item->comment;
                $performance_array[$key]['grade'] = $item->grade;
                $performance_array[$key]['academic_days'] = $item->academic_days;
                $performance_array[$key]['present_days'] = $item->present_days;
                $performance_array[$key]['absent_days'] = $item->absent_days;
                $performance_array[$key]['behaviour'] = $item->behaviour;
                $performance_array[$key]['cultural_activities'] = $item->cultural_activities;
                $performance_array[$key]['bncc'] = $item->bncc;
                $performance_array[$key]['debate'] = $item->debate;
                $performance_array[$key]['scout'] = $item->scout;
                $performance_array[$key]['sports'] = $item->sports;
                $performance_array[$key]['others'] = $item->others;

                $key++;
            }

            return $performance_array;
        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }



    public function createUpdateAcademicResultOtherPerformance(Request $request)
    {


        try {
            // return 'jahin';


            foreach ($request->StudentOtherPerformanceList as $item) {
                $result = SiteStudentPrimaryResultDetail::FindOrFail($item['id']);

                // dd($item['comment']);

                if (
                    $result['academic_days'] != $item['academic_days'] ||
                    $result['present_days'] != $item['present_days'] ||
                    $result['absent_days'] != $item['absent_days'] || $result['comment'] != $item['comment']
                ) {

                    SiteStudentPrimaryResultDetail::where('id', $item['id'])
                        ->where('student_history_id', $item['student_history_id'])
                        ->update([
                            'is_dynamic_attendace_count' => false,
                            'academic_days' => $item['academic_days'],
                            'comment' =>      $item['comment'],
                            'present_days' => $item['present_days'],
                            'absent_days' => $item['absent_days'],
                            'behaviour' => $item['behaviour'],
                            'cultural_activities' => $item['cultural_activities'],
                            'bncc' => $item['bncc'],
                            'debate' => $item['debate'],
                            'scout' => $item['scout'],
                            'sports' => $item['sports'],
                            'others' => $item['others'],
                        ]);
                }
            }
            return Response::json(['message' => 'Update Successfully'], 200);
        } catch (Exception $ex) {
            return Response::json(['message' => 'Something went Wrong!'], 405);
        }
    }

    public function updateOtherResultGenerate(Request $request)
    {


        $data = $request->all();

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            //                ->where('status', true)
            ->pluck('id');



        $year = $request->selectedYear;
        $month = $request->selectedMonth;
        $firstDayOfMonth = mktime(0, 0, 0, $month, 1, $year);


        $start = $request->date_range['start'];
        $end = $request->date_range['end'];

        $year = AcademicYear::findOrFail($request->academic_year_id);


        $start_date = Carbon::parse($start);
        $end_date = Carbon::parse($end);
        $total_daycount = $start_date->diffInDays($end_date);

        $eventCount = Event::where('activate_date', '>=', $start)
            ->where('activate_date', '<=', $end)
            ->where('status', 1)
            ->with('academicCalendarHead')
            ->count();

        $generateStudentRest = array_diff($student_list_ids->toArray(), $request->select_student_history_ids);


        if (count($generateStudentRest) > 0) {
            $tenStudentIDs = collect($generateStudentRest)->take(20);
        } else {
            $tenStudentIDs = [];
        }

        $generatedStudentIDs = array_merge($tenStudentIDs->toArray(), $request->select_student_history_ids);

        $year = AcademicYear::FindOrFail($request->academic_year_id);

        $academic_day_count = $total_daycount - $eventCount;

        foreach ($tenStudentIDs as $student_history_id) {
            $attendanceCount = StudentAttendance::where('student_history_id', $student_history_id)
                ->where('present_date', '>=', $start)
                ->where('present_date', '<=', $end)
                ->count();

            SiteStudentPrimaryResultDetail::where('student_history_id', $student_history_id)
                ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->update([
                    'academic_days' => $academic_day_count,
                    'is_dynamic_attendace_count' => true,
                    'start_attendance_date_range' => $start,
                    'end_attendance_date_range' => $end,
                    'present_days' => $attendanceCount,
                    'absent_days' => $academic_day_count - $attendanceCount
                ]);
        }


        $count_student = count($student_list_ids);
        $completed_percent = ceil(count($generatedStudentIDs) * 100 / $count_student);


        if (count($tenStudentIDs) > 0) {

            return response()->json(
                [
                    'generatedStudentIDs' => $generatedStudentIDs,
                    'count_student' => $count_student,
                    'completed_percent' => $completed_percent,
                    'student_list_ids' => $student_list_ids,
                ]
            );
        } else {
            return Response::json(['message' => 'information Save Successfully!', 'mode' => 'Saved!'], 200);
        }
    }



    public function createUpdateMeritList(Request $request)
    {

        $data = $request->all();
        //  dd(count($data['academic_section_ids']));

        $student_list_ids = StudentHistory::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->when(count($data['academic_section_ids']), function ($query) use ($data) {
                return $query->whereIn('academic_section_id', $data['academic_section_ids']);
            })
            //  ->where('status', true)
            ->pluck('id');

        //  dd($student_list_ids);

        // rank genarate start
        // $getUpdatedSiteStudentPrimaryResultDetail= SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
        //         ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
        //         ->orderBy('gpa', 'DESC')
        //         ->orderBy('fail_subject_count', 'ASC')
        //         ->orderBy('sum_of_obtain_raw_total_marks', 'DESC')
        //         ->get();

        $getUpdatedSiteStudentPrimaryResultDetail = SiteStudentPrimaryResultDetail::whereIn('student_history_id', $student_list_ids)
            ->where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->join('student_histories', 'site_student_primary_result_details.student_history_id', '=', 'student_histories.id')
            ->orderBy('gpa', 'DESC')
            ->orderBy('fail_subject_count', 'ASC')
            ->orderBy('sum_of_obtain_raw_total_marks', 'DESC')
            ->orderBy('student_histories.student_roll_number', 'ASC') // Include related field
            ->select('site_student_primary_result_details.*') // Ensure only required columns are selected
            ->get();
        // ->sortBy(function ($item) {
        //     return $item->studentHistory->student_roll_number ?? 0;
        // });

        $total_student = count($getUpdatedSiteStudentPrimaryResultDetail);

        // heihest mark list

        $hight_marks_ids = SiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
            ->whereIn('student_history_id', $student_list_ids)
            ->where('status', true)
            ->pluck('exam_dependent_academic_subject_id')->unique()->filter();

        //   dd($hight_marks_ids);
        $hight_marks_list = [];
        foreach ($hight_marks_ids as $key => $value) {
            $hight_marks_subject = SiteIndividualCombineSubjectResultStore::where('academic_result_primary_type_id', $request->academic_result_primary_type_id)
                ->whereIn('student_history_id', $student_list_ids)
                ->where('exam_dependent_academic_subject_id', $value)
                ->where('status', true)
                //    ->orderBy('obtain_raw_total_marks', 'desc')
                ->orderBy('obtain_total_marks_for_show', 'desc')
                // ->select('exam_dependent_academic_subject_id', 'obtain_raw_total_marks')
                ->select('exam_dependent_academic_subject_id', 'obtain_total_marks_for_show', 'obtain_raw_total_marks')
                ->first();



            if ($hight_marks_subject) {
                $hight_marks_list[] = $hight_marks_subject;
            }
        }

        //     dd($hight_marks_list);

        $count = 1;
        foreach ($getUpdatedSiteStudentPrimaryResultDetail as $key => $value) {

            SiteStudentPrimaryResultDetail::where('id', $value->id)
                ->update([
                    'total_student' => $total_student,
                    'student_rank' => $count,
                    'highest_marks_list' => json_encode($hight_marks_list)
                ]);

            $count++;
        }

        // rank genarate end

        return Response::json(['message' => 'Merit List Update Successfully!', 'mode' => 'Saved!'], 200);
    }
}
